<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Team_Carousel extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-team-carousel-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Carousel', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Team Carousel Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'member_img', [
				'label' => esc_html__( 'Member Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'include' => [],
				'default' => 'large',
			]
		);
        $repeater->add_control(
			'member_name', [
				'label' => esc_html__( 'Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_1', [
				'label' => esc_html__( 'Social One', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_1_link', [
				'label' => esc_html__( 'Social One Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_2', [
				'label' => esc_html__( 'Social Two', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_2_link', [
				'label' => esc_html__( 'Social Two Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_3', [
				'label' => esc_html__( 'Social Three', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_3_link', [
				'label' => esc_html__( 'Social Three Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_4', [
				'label' => esc_html__( 'Social Four', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_4_link', [
				'label' => esc_html__( 'Social Four Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'single_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'teams',
			[
				'label' => esc_html__( 'Teams Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ member_name }}}',
			]
		);

		$this->add_control(
			'big_title', [
				'label' => esc_html__( 'Big Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'arrow_icon', [
				'label' => esc_html__( 'Arrow Icon', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Subtitle-Color',
            [
                'label' => esc_html__( 'Section Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Subtitle-Typography',
                'label' => 'Section Subtitle Typography',
                'selector' => '{{WRAPPER}} .bz-section-title .sub-title',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bz-section-title h2',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Special-Title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-section-title h2 span.bz-section-title p',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Description*/
        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Description-Color',
            [
                'label' => esc_html__( 'Section Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Description-Typography',
                'label' => 'Section Description Typography',
                'selector' => '{{WRAPPER}} .bz-section-title p',
            ]
        );

        /*Big-Title*/
        $this->add_control(
            '--Big-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Big Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Big-Title-Color',
            [
                'label' => esc_html__( 'Big Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-bottom-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Big-Title-Typography',
                'label' => 'Big Title Typography',
                'selector' => '{{WRAPPER}} .bz-bottom-title',
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Icon-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Icon Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'Team_style_1',
            [
                'label' => __( 'Team Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'Name-Color',
            [
                'label' => esc_html__( 'Name Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-team-items .bz-team-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Name-Typography',
                'label' => 'Name Typography',
                'selector' => '{{WRAPPER}} .bz-team-items .bz-team-text h3',
            ]
        );

        $this->add_control(
            'Designation-Color',
            [
                'label' => esc_html__( 'Designation Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-team-items .bz-team-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Designation-Typography',
                'label' => 'Designation Typography',
                'selector' => '{{WRAPPER}} .bz-team-items .bz-team-text h3',
            ]
        );
        $this->add_control(
            'Social-Icon-Color',
            [
                'label' => esc_html__( 'Social Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-team-items .bz-team-social li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bz-team-2" class="bz-team-section-2 position-relative">
        <?php if(!empty($shape['url'])):?>
		    <span class="bz-team-shape position-absolute"><img src="<?php echo esc_url($shape['url']);?>" alt=""></span>
        <?php endif;?>
		<div class="bz-team-content-2">
			<div class="container">
				<div class="bz-team-content">
					<div class="row">
						<div class="col-lg-5">
							<div class="bz-team-text-content">
								<div class="bz-section-title pera-content headline">
                                    <?php if(!empty($subtitle)):?>
									<span class="sub-title text-uppercase"><?php echo wp_kses( $subtitle, true )?></span>
                                    <?php endif;?>
									<h2><?php echo wp_kses( $title, true )?></h2>
									<p><?php echo wp_kses( $description, true )?></p>
								</div>
                                <?php if(!empty($btn_label)):?>
                                    <div class="bz-btn-2 text-uppercase">
                                        <a href="<?php echo esc_url($btn_link['url']);?>"><?php echo esc_html($btn_label);?> <i class="fas fa-long-arrow-right"></i></a>
                                    </div>
                                <?php endif;?>
							</div>
						</div>
						<div class=" col-lg-7">
							<div class="bz-team-slider-area">
								<div class="bz-team-slider">
									<?php foreach($teams as $item):
                                        if ( ! empty( $item['single_link']['url'] ) ) {
                                            $this->add_link_attributes( 'single_link', $item['single_link'] );
                                            $target = $item['single_link']['is_external'] ? '_blank' : '';
                                        }    
                                    ?>
									<div class="bz-slider-item">
										<div class="bz-team-items">
											<div class="bz-team-img position-relative">
                                                <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'member_img' );?>
												<div class="bz-team-social position-absolute ul-li">
													<ul>
                                                        <?php if(!empty($item['social_1']) || !empty($item['social_1_link']['url'])):?>
														    <li><a href="<?php echo esc_url($item['social_1_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_1'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                                                        <?php endif;?>

                                                        <?php if(!empty($item['social_2']) || !empty($item['social_2_link']['url'])):?>
														    <li><a href="<?php echo esc_url($item['social_2_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_2'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                                                        <?php endif;?>

                                                        <?php if(!empty($item['social_3']) || !empty($item['social_3_link']['url'])):?>
														    <li><a href="<?php echo esc_url($item['social_3_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_3'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                                                        <?php endif;?>

                                                        <?php if(!empty($item['social_4']) || !empty($item['social_4_link']['url'])):?>
														    <li><a href="<?php echo esc_url($item['social_4_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_4'], [ 'aria-hidden' => 'true' ] ); ?></a></li>
                                                        <?php endif;?>
													</ul>
												</div>
											</div>
											<div class="bz-team-text text-center headline  position-relative">
												<h3>
                                                    <a href="<?php echo $item['single_link']['url']; ?>" target="<?php echo $target; ?>">
                                                        <?php echo esc_html($item['member_name']);?>
                                                    </a>
                                                </h3>
												<span class="bz-team-degi text-uppercase"><?php echo esc_html($item['designation']);?></span>
                                                <?php if(!empty($arrow_icon['url'])):?>
												<a class="team_arrow position-absolute" href="<?php echo $item['single_link']['url']; ?>" target="<?php echo $target; ?>"><img src="<?php echo esc_url($arrow_icon['url']);?>" alt=""></a>
                                                <?php endif;?>
											</div>
										</div>
									</div>
                                    <?php endforeach;?>
                                    
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
        <?php if(!empty($shape2['url'])):?>
		    <span class="bz-team-shape2 position-absolute"><img src="<?php echo esc_url($shape2['url']);?>" alt=""></span>
        <?php endif;?>
        <?php if(!empty($big_title)):?>
		    <div class="bz-bottom-title position-absolute text-uppercase"><?php echo esc_html($big_title);?></div>
        <?php endif;?>
	</section>	
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Team_Carousel() );