<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Team_Carousel_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-team-carousel-tw-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Team Two Carousel', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Team Carousel Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'tm_bg', [
				'label' => esc_html__( 'Team Background', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'shape_bg', [
				'label' => esc_html__( 'Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);

		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'member_img', [
				'label' => esc_html__( 'Member Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'include' => [],
				'default' => 'large',
			]
		);
        $repeater->add_control(
			'member_name', [
				'label' => esc_html__( 'Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'designation', [
				'label' => esc_html__( 'Designation', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_1', [
				'label' => esc_html__( 'Social One', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_1_link', [
				'label' => esc_html__( 'Social One Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_2', [
				'label' => esc_html__( 'Social Two', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_2_link', [
				'label' => esc_html__( 'Social Two Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_3', [
				'label' => esc_html__( 'Social Three', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_3_link', [
				'label' => esc_html__( 'Social Three Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_4', [
				'label' => esc_html__( 'Social Four', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'social_4_link', [
				'label' => esc_html__( 'Social Four Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'single_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'teams',
			[
				'label' => esc_html__( 'Teams Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ member_name }}}',
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Sub title*/
        $this->add_control(
            '--Sub-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Sub Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );

        /*title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-team-section .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-team-section .bizx-section-title h2',
            ]
        );

       /* list color*/
        $this->add_control(
            '--List-Style-Heading--',
            [
                'label' => esc_html__( 'List Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'List-Title-Color',
            [
                'label' => esc_html__( 'List Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-team-text-area .bizx-introduction-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'List-Title-Typography',
                'label' => 'List Title Typography',
                'selector' => '{{WRAPPER}} .bizx-team-text-area .bizx-introduction-list li',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'List-Title-Icon-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-introduction-list li:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('List Title Icon BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'Team_style_1',
            [
                'label' => __( 'Team Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tpcnteam');
        $this->start_controls_tab(
            'tab_controls_normal_team',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Name-Color',
            [
                'label' => esc_html__( 'Name Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-team-item .team-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Name-Typography',
                'label' => 'Name Typography',
                'selector' => '{{WRAPPER}} .bizx-team-item .team-text h3',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Designation-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-team-item .team-text span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Designation Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Designation-Typography',
                'label' => 'Designation Typography',
                'selector' => '{{WRAPPER}} .bizx-team-item .team-text span',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Team-member-BG-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-team-item:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Team Member BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Social-Icon-Color',
            [
                'label' => esc_html__( 'Social Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-team-item .team-text .team-social a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover_team',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Designation-Hover-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-team-item:hover .team-text span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Designation Hover Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Team-member-Hover-BG-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-team-item:after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Team Member Hover BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bizx-team" class="bizx-team-section position-relative" data-background="<?php echo esc_url($settings['tm_bg']['url']);?>">
        <?php if(!empty($settings['shape_bg']['url'])):?>
		    <span class="bizx-team-side-img position-absolute" data-parallax='{"y" : 50}'><img src="<?php echo esc_url($settings['shape_bg']['url']);?>" alt=""></span>
        <?php endif;?>
		<div class="bizx-team-content position-relative">
			<div class="row">
				<div class="col-lg-5">
					<div class="bizx-team-text-area">
						<div class="bizx-section-title pera-content bzx-headline wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
							<div class="subtitle">
								<?php echo wp_kses($settings['subtitle'], true);?>
							</div>
							<h2><?php echo wp_kses($settings['title'], true);?></h2>
						</div>
						<div class="bizx-introduction-list ul-li-block wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
                            <?php echo wp_kses($settings['description'], true);?>
						</div>
                        <?php if(!empty($settings['btn_label'])):?>
						<div class="bizx-btn text-uppercase wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1000ms">
							<a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?></a>
						</div>
                        <?php endif;?>
					</div>
				</div>
				<div class="col-lg-7">
					<div class="bizx-team-slider-area position-relative">
						<div class="bizx-team-slider">
							<?php foreach($settings['teams'] as $item):?>
							<div class="bizx-team-item-slide">
								<div class="bizx-team-item position-relative text-center">
									<div class="team-img">
                                    <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'member_img' );?>
									</div>
									<div class="team-text bzx-headline">
										<h3><a href="<?php echo esc_url($item['single_link']['url']);?>"><?php echo esc_html($item['member_name']);?></a></h3>
										<span><?php echo esc_html($item['designation']);?></span>
										<div class="team-social">
                                            <?php if(!empty($item['social_1']) || !empty($item['social_1_link']['url'])):?>
                                                <a href="<?php echo esc_url($item['social_1_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_1'], [ 'aria-hidden' => 'true' ] ); ?></a>
                                            <?php endif;?>

                                            <?php if(!empty($item['social_2']) || !empty($item['social_2_link']['url'])):?>
                                                <a href="<?php echo esc_url($item['social_2_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_2'], [ 'aria-hidden' => 'true' ] ); ?></a>
                                            <?php endif;?>

                                            <?php if(!empty($item['social_3']) || !empty($item['social_3_link']['url'])):?>
                                                <a href="<?php echo esc_url($item['social_3_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_3'], [ 'aria-hidden' => 'true' ] ); ?></a>
                                            <?php endif;?>

                                            <?php if(!empty($item['social_4']) || !empty($item['social_4_link']['url'])):?>
                                                <a href="<?php echo esc_url($item['social_4_link']['url']);?>"><?php \Elementor\Icons_Manager::render_icon( $item['social_4'], [ 'aria-hidden' => 'true' ] ); ?></a>
                                            <?php endif;?>
										</div>
									</div>
								</div>
							</div>
                            <?php endforeach;?>
						</div>
						<div class="bizx-carousel-btn">
							<div class="carousel_nav text-center">
								<button type="button" class="team_left_arrow text-uppercase"><i class="far fa-long-arrow-left"></i></button>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="bizx-carousel-btn">
			<div class="carousel_nav text-center">
				<button type="button" class="team_right_arrow text-uppercase"><i class="far fa-long-arrow-right"></i></button>
			</div>
		</div>
		</div>
		
	</section>	    
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Team_Carousel_Two() );