<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Sponsor_Slider_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-sponsor-slider-two-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Sponsor Carousel Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Slider Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'sponsor_img', [
				'label' => esc_html__( 'Sponsor Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'sliders',
			[
				'label' => esc_html__( 'Add Slide Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        

		$this->end_controls_section();
		
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-sponsor" class="bzx-sponsor-section">
		<div class="container">
			<div class="bzx-sponsor-content">
				<div class="bzx-sponsor-slider">
                    <?php foreach($settings['sliders'] as $item):?>
					<div class="bzx-slider-item">
						<div class="bzx-sponsor-item">
							<img src="<?php echo esc_url($item['sponsor_img']['url']);?>" alt="">
						</div>
					</div>
                    <?php endforeach;?>
				</div>
			</div>
		</div>
	</section>		
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Sponsor_Slider_Two() );