<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Skill_Content extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-skill-content-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Skill Content', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape1', [
				'label' => esc_html__( 'Shape 1 Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2 Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Is Active', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$repeater->add_control(
			'tab_thumb_img', [
				'label' => esc_html__( 'Tab Thumb Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'tab_large_img', [
				'label' => esc_html__( 'Tab Large Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Add Tab Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'list_description', [
				'label' => esc_html__( 'List Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);

        $repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'circle_bar',
			[
				'label' => esc_html__( 'Add Progress Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'info_title', [
				'label' => esc_html__( 'Info Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'info_desc', [
				'label' => esc_html__( 'Info Desc', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Sub title*/
        $this->add_control(
            '--Sub-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Sub Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title h2',
            ]
        );

        /*Tab Style*/
        $this->add_control(
            '--Tab-Style-Heading--',
            [
                'label' => esc_html__( 'Tab Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Tab-Border-Left-Color',
            [
                'label' => esc_html__( 'Tab Border Left Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-introduction-img-tab .bzx-service-item-hos-tab-btn .nav-link.active:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Tab-Border-Right-Color',
            [
                'label' => esc_html__( 'Tab Border Right Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-introduction-img-tab .bzx-service-item-hos-tab-btn .nav-link.active:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab-Number-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-introduction-img-tab .bzx-service-item-hos-tab-btn .intro-hos-tab-btn-item .intro-btn-img span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Tab Number Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-introduction-img-tab .bzx-service-item-hos-tab-btn .nav-link.active .intro-hos-tab-btn-item .intro-btn-text',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Tab Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tab-title-Typography',
                'label' => 'Tab Title Typography',
                'selector' => '{{WRAPPER}} .bizx-introduction-img-tab .bzx-service-item-hos-tab-btn .nav-link.active .intro-hos-tab-btn-item .intro-btn-text',
            ]
        );

        /*Info style*/
        $this->add_control(
            '--Info-Style-Heading--',
            [
                'label' => esc_html__( 'Info Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Info-Title-Color',
            [
                'label' => esc_html__( 'Info Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-introduction-text-area h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Info-Title-Typography',
                'label' => 'Info Title Typography',
                'selector' => '{{WRAPPER}} .bizx-introduction-text-area h3',
            ]
        );
        $this->add_control(
            'Info-Description-Color',
            [
                'label' => esc_html__( 'Info Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-introduction-text-area p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Info-Description-Typography',
                'label' => 'Info Description Typography',
                'selector' => '{{WRAPPER}} .bizx-introduction-text-area p',
            ]
        );
        $this->add_control(
            'List-Title-Color',
            [
                'label' => esc_html__( 'List Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-introduction-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'List-Title-Typography',
                'label' => 'List Title Typography',
                'selector' => '{{WRAPPER}} .bizx-introduction-list li',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'List-Title-Icon-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-introduction-list li:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('List Title Icon BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

       /* Counter style*/
        $this->add_control(
            '--Counter-Style-Heading--',
            [
                'label' => esc_html__( 'Counter Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Number-Color',
            [
                'label' => esc_html__( 'Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-circle-progress-item .count-box' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Number-Typography',
                'label' => 'Number Typography',
                'selector' => '{{WRAPPER}} .bizx-circle-progress-item .count-box',
            ]
        );
        $this->add_control(
            'Progressbar-Title-Color',
            [
                'label' => esc_html__( 'Progressbar Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-circle-progress-item h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Progressbar-Title-Typography',
                'label' => 'Progressbar Title Typography',
                'selector' => '{{WRAPPER}} .bizx-circle-progress-item h3',
            ]
        );
        $this->add_control(
            'Progressbar-Circle-Color',
            [
                'label' => esc_html__( 'Progressbar Circle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
            ]
        );


        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div id="bizx-introduction" class="bizx-introduction-section position-relative">
        <?php if(!empty($settings['shape1']['url'])):?>
		    <span class="bizx-introduction-shape-bg1 position-absolute"><img src="<?php echo esc_url($settings['shape1']['url']);?>" alt=""></span>
        <?php endif;?>
        <?php if(!empty($settings['shape2']['url'])):?>
		    <span class="bizx-introduction-shape-bg2 position-absolute"><img src="<?php echo esc_url($settings['shape2']['url']);?>" alt=""></span>
        <?php endif;?>
		<div class="container">
			<div class="bizx-section-title text-center pera-content bzx-headline wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
                <?php if(!empty($settings['sub_title'])):?>
				<div class="subtitle">
					<?php echo esc_html($settings['sub_title']);?>
				</div>
                <?php endif;?>
				<h2><?php echo wp_kses($settings['title'], true)?></h2>
			</div>
			<div class="bizx-introduction-content">
				<div class="row">
					<div class="col-lg-6">
						<div class="bizx-introduction-img-tab position-relative">
							<div class="tab-content wow slideInLeft" data-wow-delay="400ms" data-wow-duration="1000ms" id="myTabContent">
                                <?php foreach($settings['tabs'] as $item):?>
                                    <div class="tab-pane animated fadeInUp <?php if($item['is_active'] == 'yes'){echo esc_attr('show active');}?> " id="personal<?php echo esc_attr($item['_id']);?>" role="tabpanel" aria-labelledby="home-tab">
                                        <div class="bizx-introduction-img-area">
                                            <img src="<?php echo esc_url($item['tab_large_img']['url']);?>" alt="">
                                        </div>
                                    </div>
								<?php endforeach;?>
							</div>
							<div class="bzx-service-item-hos-tab-btn wow fadeInUp" data-wow-delay="700ms" data-wow-duration="1000ms">
								<ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <?php foreach($settings['tabs'] as $item):?>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link <?php if($item['is_active'] == 'yes'){echo esc_attr('active');}?>"  data-bs-toggle="tab" data-bs-target="#personal<?php echo esc_attr($item['_id']);?>" type="button" role="tab" >
                                                <div class="intro-hos-tab-btn-item d-flex align-items-center">
                                                    <div class="intro-btn-img position-relative">
                                                        <div class="bizx-img-shade wow"></div>
                                                        <img src="<?php echo esc_url($item['tab_thumb_img']['url']);?>" alt="">
                                                        <?php if(!empty($item['count'])):?>
                                                        <span><?php echo esc_html($item['count']);?></span>
                                                        <?php endif;?>
                                                    </div>
                                                    <div class="intro-btn-text">
                                                        <?php echo wp_kses($item['title'], true);?>
                                                    </div>
                                                </div>
                                            </button>
                                        </li>
                                    <?php endforeach;?>
								</ul>
							</div>
						</div>
					</div>
					<div class="col-lg-6">
						<div class="bizx-introduction-text-area bzx-headline pera-content">
							<h3><?php echo wp_kses($settings['info_title'], true);?></h3>
							<p><?php echo wp_kses($settings['info_desc'], true);?></p>
							<div class="bizx-introduction-list ul-li-block">
								<?php echo wp_kses($settings['list_description'], true);?>
							</div>
							<div class="bizx-circle-progress-area d-flex">
								<?php foreach($settings['circle_bar'] as $item):?>
								<div class="bizx-circle-progress-item">
									<div class="counter-boxed  bzx-headline align-items-center d-flex">
										<div class="graph-outer text-center  position-relative">
											<input type="text" class="dial" data-fgColor="<?php echo esc_attr($settings['Progressbar-Circle-Color']); ?>" data-bgColor="#eff7f8" data-width="115" data-height="115"   value="<?php echo esc_attr($item['count']);?>" >
											<div class="inner-text count-box"><span class="count-text" data-stop="<?php echo esc_attr($item['count']);?>" data-speed="4500"></span>%</div>
										</div>
										<h3><?php echo esc_attr($item['title']);?></h3>
									</div>
								</div>
                                <?php endforeach;?>
							</div>
                            <?php if(!empty($settings['btn_label'])):?>
                                <div class="bizx-btn text-uppercase">
                                    <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?></a>
                                </div>
                            <?php endif;?>
						</div>
					</div>
				</div>
			</div>
		</div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Skill_Content() );