<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Service_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-service-two-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Service Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'big_title', [
				'label' => esc_html__( 'Big Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'service_img', [
				'label' => esc_html__( 'Service Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Tab', 'bizex-tools' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$repeater->add_control(
			'service_icon', [
				'label' => esc_html__( 'Service Icon', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'service_hover_icon', [
				'label' => esc_html__( 'Service Hover Icon', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'service_img', [
				'label' => esc_html__( 'Service Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'descriptions', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'tabs_items',
			[
				'label' => esc_html__( 'Add Tab Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->add_control(
			'more_service', [
				'label' => esc_html__( 'More Service Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'more_link', [
				'label' => esc_html__( 'More Service Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Subtitle-Color',
            [
                'label' => esc_html__( 'Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Subtitle-Typography',
                'label' => 'Subtitle Typography',
                'selector' => '{{WRAPPER}} .bzx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Subtitle-BG-Color',
            [
                'label' => esc_html__( 'Subtitle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bzx-section-title h2',
            ]
        );
        /*Big-Title*/
        $this->add_control(
            '--Big-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Big Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Big-Title-Color',
            [
                'label' => esc_html__( 'Big Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-top-content .title-bg' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Big-Title-Typography',
                'label' => 'Big Title Typography',
                'selector' => '{{WRAPPER}} .bzx-section-top-content .title-bg',
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bzx-btn a',
            ]
        );
        $this->add_control(
            'Button-BG-Color',
            [
                'label' => esc_html__( 'Button BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-BG-Color',
            [
                'label' => esc_html__( 'Button Hover BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Hover-Icon-BG-Color',
            [
                'label' => esc_html__( 'Button Hover Icon BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a:hover i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();




        /*Tab-Item*/
        $this->add_control(
            '--Tab-Item-Style-Heading--',
            [
                'label' => esc_html__( 'Tab Item Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Tab-BG-Color',
            [
                'label' => esc_html__( 'Tab BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-item-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Tab-Border-Color',
            [
                'label' => esc_html__( 'Tab Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-item-btn' => 'border-bottom-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Tab-Active-BG-Color',
            [
                'label' => esc_html__( 'Tab Active BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-item-btn:before' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Tab-Title-Color',
            [
                'label' => esc_html__( 'Tab Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-item-btn .bzx-service-item-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Tab-Title-Typography',
                'label' => 'Tab Title Typography',
                'selector' => '{{WRAPPER}} .bzx-service-item-btn .bzx-service-item-text h3',
            ]
        );

        $this->add_control(
            'Tab-Content-Title-Color',
            [
                'label' => esc_html__( 'Tab Content Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Tab-Content-Title-Typography',
                'label' => 'Tab Content Title Typography',
                'selector' => '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text h3',
            ]
        );
        $this->add_control(
            'Tab-Content-Description-Color',
            [
                'label' => esc_html__( 'Tab Content Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Tab-Content-Description-Typography',
                'label' => 'Tab Content Description Typography',
                'selector' => '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text p',
            ]
        );
        $this->add_control(
            'Tab-Button-Color',
            [
                'label' => esc_html__( 'Tab Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text .read_more span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text .read_more i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Tab-Button-Typography',
                'label' => 'Tab Button Typography',
                'selector' => '{{WRAPPER}} .bzx-service-img-text .bzx-service-title-text .read_more span',
            ]
        );


        /*More Service*/
        $this->add_control(
            '--More-Service-Style-Heading--',
            [
                'label' => esc_html__( 'More Service Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'More-Service-Color',
            [
                'label' => esc_html__( 'More Service Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-more-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'More-Service-Typography',
                'label' => 'More Service Typography',
                'selector' => '{{WRAPPER}} .bzx-service-more-btn a',
            ]
        );
        $this->add_control(
            'More-Service-BG-Color',
            [
                'label' => esc_html__( 'More Service BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-service-more-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();


	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-service" class="bzx-service-section position-relative">
		<div class="container">
			<div class="bzx-section-top-content position-relative d-flex justify-content-between align-items-center">
                <?php if(!empty($settings['big_title'])):?>
				    <span class="title-bg position-absolute" data-parallax='{"x" : -100}'><?php echo wp_kses($settings['big_title'], true)?>    </span>
                <?php endif;?>
				<div class="bzx-section-title bzx-headline pera-content position-relative">
                    <?php if(!empty($settings['sub_title'])):?>
					<div class="subtitle text-uppercase wow fadeInDown" data-wow-delay="200ms" data-wow-duration="1500ms">
						<?php echo esc_html($settings['sub_title']);?>
					</div> 
                    <?php endif;?>
                    <?php if(!empty($settings['title'])):?>
					    <h2 data-splitting><?php echo wp_kses($settings['title'], true);?></h2>
                    <?php endif;?>
				</div>
                <?php if(!empty($settings['btn_label'])):?>
                    <div class="bzx-btn text-uppercase">
                        <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?> <i class="fal fa-long-arrow-right"></i></a>
                    </div>
                <?php endif;?>
			</div>
		</div>
		<div class="bzx-service-content">
			<div class="bzx-service-content-wrap d-flex">
                <?php if(!empty($settings['service_img']['url'])):?>
                    <div class="bzx-service-side-img wow slideInLeft" data-wow-delay="200ms" data-wow-duration="1500ms">
                        <img src="<?php echo esc_url($settings['service_img']['url']);?>" alt="">
                    </div>
                <?php endif;?>
				<div class="bzx-service-item-text-wrap position-relative">
					<div class="tab-content" id="myTabContent">
                        <?php foreach($settings['tabs_items'] as $item):?>
						<div class="tab-pane animated fadeInUp <?php if($item['is_active'] == 'yes'){ echo esc_attr('show active');}?>" id="personal<?php echo esc_attr($item['_id']);?>" role="tabpanel" aria-labelledby="home-tab<?php echo esc_attr($item['_id']);?>">
							<div class="bzx-service-img-text d-flex align-items-center">
								<div class="bzx-service-img">
									<img src="<?php echo esc_url($item['service_img']['url']);?>" alt="">
								</div>
								<div class="bzx-service-title-text bzx-headline pera-content">
									<h3><a href="<?php echo esc_url($item['btn_link']['url']);?>"><?php echo wp_kses($item['title'], true);?></a></h3>
									<p><?php echo wp_kses($item['descriptions'], true);?></p>
                                    <?php if(!empty($settings['btn_label'])):?>
									<a class="read_more" href="<?php echo esc_url($item['btn_link']['url']);?>"><span><?php echo esc_html($item['btn_label']);?></span> <i class="fal fa-arrow-right"></i></a>
                                    <?php endif;?>
								</div>
							</div>
						</div>
						<?php endforeach;?>
					</div>
					<div class="bzx-service-item-tab-more-btn">
						<div class="bzx-service-item-hos-tab-btn">
							<ul class="nav nav-tabs" id="myTab" role="tablist">
                            <?php foreach($settings['tabs_items'] as $item):?>
								<li class="nav-item" role="presentation">
									<button class="nav-link <?php if($item['is_active'] == 'yes'){ echo esc_attr('active');}?>" id="home-tab<?php echo esc_attr($item['_id']);?>" data-bs-toggle="tab" data-bs-target="#personal<?php echo esc_attr($item['_id']);?>" type="button" role="tab" >
										<div class="bzx-service-item-btn position-relative">
											<div class="service-item-icon position-relative">
                                                <?php if(!empty($item['service_icon']['url'])):?>
												<div class="ser-icon-main">
													<img src="<?php echo esc_url($item['service_icon']['url']);?>" alt="">
												</div>
                                                <?php endif;?>
                                                <?php if(!empty($item['service_hover_icon']['url'])):?>
												<div class="ser-icon-hover">
                                                    <img src="<?php echo esc_url($item['service_hover_icon']['url']);?>" alt="">
												</div>
                                                <?php endif;?>
											</div>
											<div class="bzx-service-item-text bzx-headline">
												<h3><?php echo wp_kses($item['title'], true);?></h3>
											</div>
										</div>
									</button>
								</li>
								<?php endforeach;?>
							</ul>
						</div>
					</div>
                    <?php if(!empty($settings['more_service'])):?>
                        <div class="bzx-service-more-btn text-uppercase">
                            <a href="<?php echo esc_url($settings['more_link']['url']);?>"><?php echo esc_html($settings['more_service']);?></a>
                        </div>
                    <?php endif;?>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Service_Two() );