<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Service_3 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-service-3-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Three', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Service Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape1', [
				'label' => esc_html__( 'Shape 1', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'placeholder' => esc_html__( 'Sub title Here', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'placeholder' => esc_html__( 'title Here', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'placeholder' => esc_html__( 'Description Here', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'animation_delay', [
				'label' => esc_html__( 'Animation Delay', 'bizex-tools' ),
				'placeholder' => esc_html__( '0ms', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'service_icon', [
				'label' => esc_html__( 'Service Icon Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'services_item',
			[
				'label' => esc_html__( 'Add Service Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style_tb_option',
			[
				'label' => esc_html__( 'Service Style', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'Section-BG-Color',
            [
                'label' => esc_html__( 'Section-BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-service-section' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
			'c_width',
			[
				'label' => esc_html__( 'Container Width', 'bizex-tools' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1800,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .container' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
            '--Section-Style-Option--',
            [
                'label' => esc_html__( 'Section Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title h2',
            ]
        );
        $this->add_control(
            'Section-Description-Color',
            [
                'label' => esc_html__( 'Section Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Description-Typography',
                'label' => 'Section Description Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title p',
            ]
        );
		$this->end_controls_section();
        $this->start_controls_section(
            'Services_Content_Style_1',
            [
                'label' => __( 'Services Content Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Service-Icon-BG-Color',
            [
                'label' => esc_html__( 'Service-Icon-BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-service-item .bizx-service-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Service-Title-Color',
            [
                'label' => esc_html__( 'Service-Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-service-item .bizx-service-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Service-Title-Typography',
                'label' => 'Service-Title Typography',
                'selector' => '{{WRAPPER}} .bizx-service-item .bizx-service-text h3',
            ]
        );
        $this->add_control(
            'Service-Info-Color',
            [
                'label' => esc_html__( 'Service-Info Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-service-item .bizx-service-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Service-Info-Typography',
                'label' => 'Service-Info Typography',
                'selector' => '{{WRAPPER}} .bizx-service-item .bizx-service-text p',
            ]
        );
        $this->add_control(
            'Service-Box-Border-Color',
            [
                'label' => esc_html__( 'Service-Box-Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-service-item' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Service-Box-Hover-Border-Color',
            [
                'label' => esc_html__( 'Service-Box-Hover-Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-service-item:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bizx-service" class="bizx-service-section position-relative">

        <?php if(!empty($settings['shape1']['url'])):?>
		    <span class="bizx-service-shape1 position-absolute" data-parallax='{"x" : 50}'><img src="<?php echo esc_url($settings['shape1']['url']);?>" alt=""></span>
        <?php endif;?>

        <?php if(!empty($settings['shape2']['url'])):?>
		    <span class="bizx-service-shape2 position-absolute"><img src="<?php echo esc_url($settings['shape2']['url']);?>" alt=""></span>
        <?php endif;?>
        
		<div class="container">
			<div class="bizx-service-content position-relative">
				<div class="bizx-section-title text-center pera-content bzx-headline wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1000ms">
                    <?php if(!empty($settings['subtitle'])):?>
                        <div class="subtitle">
                            <?php echo wp_kses($settings['subtitle'], true);?>
                        </div>
                    <?php endif;?>

                    <?php if(!empty($settings['title'])):?>
					    <h2><?php echo wp_kses($settings['title'], true);?></h2>
                    <?php endif;?>

                    <?php if(!empty($settings['description'])):?>
					    <p><?php echo wp_kses($settings['description'], true);?></p>
                    <?php endif;?>

				</div>
				<div class="row">
                    <?php foreach($settings['services_item'] as $item):?>
					<div class="col-lg-6 wow fadeInUp" data-wow-delay="<?php echo esc_attr($item['animation_delay']);?>" data-wow-duration="1000ms">
						<div class="bizx-service-item position-relative">
							<div class="bizx-service-icon d-flex align-items-center justify-content-center">
								<img src="<?php echo esc_url($item['service_icon']['url']);?>" alt="">
							</div>
							<div class="bizx-service-text bzx-headline">
								<h3><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['title']);?></a></h3>
								<p><?php echo wp_kses($item['description'], true);?></p>
							</div>
						</div>
					</div>
                    <?php endforeach;?>
				</div>
			</div>
		</div>
	</section>	
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Service_3() );