<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Service_4 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-service-4-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Four', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Service Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'service_icon', [
				'label' => esc_html__( 'Service Icon Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'services_item',
			[
				'label' => esc_html__( 'Add Service Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
		
        $this->add_control(
            'btn',
            [
                'label' => __('Button', 'cando'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'cando'),
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => __( 'Button Icon', 'cando' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'brand',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-text h3',
            ]
        );
        $this->add_control(
            'nvcc',
            [
                'label' => __( 'Nav Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servcie-slider-2 .owl-nav .owl-prev:hover, {{WRAPPER}} .servcie-slider-2 .owl-nav .owl-next:hover' => 'color: {{VALUE}}; border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'post_aoverlaya',
            [
                'label' => __( 'Service Icon BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'icon_c',
            [
                'label' => __( 'Icon Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-img .servcie-inner-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'posta_overlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-img .servcie-inner-icon',
            ]
        );
        $this->add_control(
            'icon_ch',
            [
                'label' => __( 'Icon Hover Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-img .servcie-inner-icon:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'posta_overlayaaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-img .servcie-inner-icon:hover',
            ]
        );
        $this->add_control(
            'post_overlaya',
            [
                'label' => __( 'Service BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-text',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlaya',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .servcie-innerbox-2 .servcie-inner-text:before',
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
	
        $settings = $this->get_settings_for_display();


    echo '<!-- Start of service section
	============================================= -->
	<section id="can-service" class="can-service-section">
			<div class="can-servie-content-wrap">
				<div id="service-slide-id" class="service-silder">
					<div class="service-list-items"> 
						<div class="row">';
                        foreach($settings['services_item'] as $item){
                    echo '<div class="col-lg-6">
								<div class="service-img-text clearfix headline position-relative">
									<span class="service-shape1 position-absolute">'.get_wp_image($settings['shape1']).'</span>
									<span class="service-shape2 position-absolute">'.get_wp_image($settings['shape1']).'</span>
									<div class="service-list-img float-left">
                                        <img src="'.esc_url($item['service_icon']['url']).'">
                                    ';
                                    echo '</div>
									<div class="service-list-text">
										<h3><a href="' . $item['link']['url'] . '">' . $item['title'] . '</a></h3>
									</div>
									<div class="service-list-icon text-center">
										<a href="' . $item['link']['url'] . '">';\Elementor\Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']); echo'</a>
									</div>
								</div>
							</div>';
                        }
                echo'</div>
					</div>
				</div>
			</div>
	</section>				
<!-- End of service section
	============================================= -->';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Service_4() );