<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Service_6 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-services3';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Six', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Service Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Service Icon', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'services_item',
			[
				'label' => esc_html__( 'Add Service Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->add_control(
            'btn',
            [
                'label' => __('Button', 'cando'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'cando'),
            ]
        );
        $this->add_control(
            'btn_link',
            [
                'label' => __('Button Link', 'cando'),
                'type' => Controls_Manager::URL,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-innerbox-3 .service-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .service-innerbox-3 .service-text h3',
            ]
        );
        $this->add_control(
            'post_titleii_color',
            [
                'label' => __( 'Info Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-innerbox-3 .service-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttiiih',
                'label' => __( 'Info Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .service-innerbox-3 .service-text p',
            ]
        );
        $this->add_control(
            'ic_color',
            [
                'label' => __( 'Icon Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-innerbox-3 .service-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'ic_aacolor',
            [
                'label' => __( 'Icon Background', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-innerbox-3 .service-icon:after' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'iasdsc_aacolor',
            [
                'label' => __( 'Hover Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-innerbox-3:hover .service-icon:before' => 'border-color: {{VALUE}}',
                    '{{WRAPPER}} .service-innerbox-3:hover .service-icon i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'iiboxborder',
                'label' => __( 'Icon Border', 'cando' ),
                'selector' => '{{WRAPPER}} .service-innerbox-3 .service-icon:before',
            ]
        );
        $this->add_control(
            'post_titlebbii_color',
            [
                'label' => __( 'Button Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttiiihbb',
                'label' => __( 'Button Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .service-btn a',
            ]
        );
        $this->add_control(
            'icbb_aacolor',
            [
                'label' => __( 'Button Background', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
	
        $settings = $this->get_settings_for_display();


        echo '<!-- Start of service section
	============================================= -->
	<section id="service-3" class="service-section-3">
			<div class="service-content-3 position-relative">
				<div class="row">';
                    foreach($settings['services_item'] as $item){
                    echo '<div class="col-lg-4 col-md-6">
						<div class="service-innerbox-3">
							<div class="service-icon float-left text-center position-relative">';
                            \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] );
							echo '</div>
							<div class="service-text headline pera-content">
								<h3><a href="' . $item['link']['url'] . '">' . $item['title'] . '</a></h3>
								<p>' . $item['description'] . '</p>
							</div>
						</div>
					</div>';
                   }
            echo'</div>
			</div>';
                    echo '<div class="service-btn d-flex justify-content-center">
				<a href="' . esc_url($settings['btn_link']['url']) . '">' . $settings['btn'] . '</a>
			</div>';
	echo '</section>		
<!-- End of service section
	============================================= -->	';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Service_6() );