<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Service_5 extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-service-5-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Service Five', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Service Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'service_icon', [
				'label' => esc_html__( 'Service Icon Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'icon', [
				'label' => esc_html__( 'Service Icon', 'bizex-tools' ),
				'type' => Controls_Manager::ICONS,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $this->add_control(
			'services_item',
			[
				'label' => esc_html__( 'Add Service Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
        $this->add_control(
            'btn',
            [
                'label' => __('Button', 'cando'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Read More', 'cando'),
            ]
        );
        $this->add_control(
            'btn_icon_d',
            [
                'label' => __( 'Button Icon', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'bizex-tools' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-img-text .service-list-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .service-img-text .service-list-text h3',
            ]
        );
        $this->add_control(
            'post_title_h_color',
            [
                'label' => __( 'Title Hover Color', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-img-text .service-list-text h3:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'post_aoverlaya',
            [
                'label' => __( 'Service Icon BG', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'icon_c',
            [
                'label' => __( 'Icon Color', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-img-text .service-list-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'posta_overlayaa',
                'label' => __( 'Overlay', 'bizex-tools' ),
                'types' => [ 'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .service-img-text .service-list-icon',
            ]
        );
        $this->add_control(
            'icon_ch',
            [
                'label' => __( 'Icon Hover Color', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-img-text:hover .service-list-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'posta_overlayaaa',
                'label' => __( 'Overlay', 'bizex-tools' ),
                'types' => [ 'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .service-img-text:hover .service-list-icon',
            ]
        );
        $this->add_control(
            'post_overlaya',
            [
                'label' => __( 'Service BG', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlayaa',
                'label' => __( 'Overlay', 'bizex-tools' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .service-img-text',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlaya',
                'label' => __( 'Overlay', 'bizex-tools' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .service-img-text:hover',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Row Gap', 'bizex-tools' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .service-img-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
	}


	protected function render() {
	
        $settings = $this->get_settings_for_display();


        echo '<!-- Start of servcie section
        ============================================= -->
        <section id="servcie-2" class="servcie-section-2">
            <div class="servcie-content-2">
                <div class="servcie-slider-2">';
                foreach($settings['services_item'] as $item){
                        echo '<div class="servcie-innerbox-2">
                        <div class="servcie-inner-img position-relative">
                        <img src="'.esc_url($item['service_icon']['url']).'">
                        ';
                            echo '<div class="servcie-inner-icon text-center">';
                            \Elementor\Icons_Manager::render_icon( $item['icon'], [ 'aria-hidden' => 'true' ] );
                            echo '</div>
                        </div>
                        <div class="servcie-inner-text headline pera-content">
                            <h3><a href="' . $item['link']['url'] . '">' . $item['title'] . '</a></h3>
                            <p>' . $item['description'] . '</p>
                            <a class="serve-more" href="' . $item['link']['url'] . '">'.$settings['btn'].' ';\Elementor\Icons_Manager::render_icon( $settings['btn_icon_d'], [ 'aria-hidden' => 'true' ] ); echo'</a>
                        </div>
                    </div>';
                    }
                echo'</div>
            </div>
        </section>		
    <!-- End of servcie section
        ============================================= -->';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Service_5() );