<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Project extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-project-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'project_img', [
				'label' => esc_html__( 'Project Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'include' => [],
				'default' => 'full',
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'project_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'projects',
			[
				'label' => esc_html__( 'Add Project Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

       /*Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Subtitle-Color',
            [
                'label' => esc_html__( 'Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
                'label' => esc_html__( 'Sub Title Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-section-title .subtitle',
			]
		);
        $this->add_control(
            'Subtitle-BG-Color',
            [
                'label' => esc_html__( 'Subtitle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__( 'Title Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-section-title h2',
			]
		);

        /*Project-Title*/
        $this->add_control(
            '--Project-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Project Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Project-Title-Color',
            [
                'label' => esc_html__( 'Project Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-project-item .project-text h3' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .bzx-project-item .project-text .project-arrow i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'pro_typography',
                'label' => esc_html__( 'Project Title Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-project-item .project-text h3',
			]
		);
        $this->add_control(
            'Project-Title-Left-Border-Color',
            [
                'label' => esc_html__( 'Project Title Left Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-project-item .project-text' => 'border-left-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Project-Hover-Background-Color',
            [
                'label' => esc_html__( 'Project Hover Background Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-project-item .project-text:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-project" class="bzx-project-section position-relative">
		<div class="container">
			<div class="bzx-section-top-content position-relative d-flex justify-content-between align-items-center">
				<div class="bzx-section-title  bzx-headline pera-content position-relative">
                    <?php if(!empty($settings['sub_title'])):?>
                        <div class="subtitle text-uppercase">
                            <?php echo wp_kses($settings['sub_title'], true)?>
                        </div> 
                    <?php endif;?>
					<?php if(!empty($settings['title'])):?>
					    <h2 data-splitting><?php echo wp_kses($settings['title'], true)?></h2>
                    <?php endif;?>
				</div>
				<div class="bzx-project-carousel bzx-carousel-btn text-uppercase">
					<div class="carousel_nav text-center position-relative">
						<button type="button" class="bzx_project_left_arrow text-uppercase"><i class="far fa-long-arrow-left"></i></button>
						<button type="button" class="bzx_project_right_arrow text-uppercase"><i class="far fa-long-arrow-right"></i></button>
					</div>
				</div>
			</div>
			<div class="bzx-project-content">
				<div class="bzx-project-slider">
					<?php foreach($settings['projects'] as $item):
                    if ( ! empty( $item['project_link']['url'] ) ) {
                        $this->add_link_attributes( 'project_link', $item['project_link'] );
                    }    
                    ?>
					<div class="bzx-slider-item">
						<div class="bzx-project-item position-relative">
							<div class="project-img">
								<?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'project_img' );?>
							</div>
							<div class="project-text bzx-headline">
								<h3><a <?php echo $this->get_render_attribute_string( 'project_link' ); ?>><?php echo wp_kses($item['title'], true);?></a></h3>
								<div class="project-arrow">
									<a <?php echo $this->get_render_attribute_string( 'project_link' ); ?>><i class="fal fa-long-arrow-right"></i></a>
								</div>
							</div>
						</div>
					</div>
                    <?php endforeach;?>
				</div>
			</div>
		</div>
	</section>	
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Project() );