<?php

/**
 * Elementor Single Widget
 * @package radios Extension
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Projects_Masonary_Filter extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bzx-project-ms-filter-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Masonary Filter', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bz_filter_opt',
			[
				'label' => esc_html__( 'Projects Filter Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'all_text', [
				'label' => esc_html__( 'All Text', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'style',
			[
				'label' => esc_html__( 'Border Style', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__( 'Style 1', 'bizex-tools' ),
					'2' => esc_html__( 'Style 2', 'bizex-tools' ),
				],
			]
		);
		
        $repeater->add_control(
			'category', [
				'label' => esc_html__( 'Category', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project-img', [
				'label' => esc_html__( 'Project Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'include' => [],
				'default' => 'large',
			]
		);
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Project Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'excerpt', [
				'label' => esc_html__( 'Project Excerpt', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        
		$this->add_control(
			'projects',
			[
				'label' => esc_html__( 'Add Project Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->add_control(
			'arrow', [
				'label' => esc_html__( 'Arrow', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'view_btn', [
				'label' => esc_html__( 'View Button', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'view_btn_link', [
				'label' => esc_html__( 'View Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Category*/
        $this->add_control(
            '--Category-Style-Heading--',
            [
                'label' => esc_html__( 'Category Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Category-Color',
            [
                'label' => esc_html__( 'Category Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text .portfolio-cat' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Category-Typography',
                'label' => 'Category Typography',
                'selector' => '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text .portfolio-cat',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text h3',
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Icon-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Icon Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>
    <section id="bz-portfolio" class="bz-portfolio-section">
		<div class="container">
			<div class="bz-portfolio-filter-tab">
				<div class="filtr-container-area grid clearfix" data-isotope="{ &quot;masonry&quot;: { &quot;columnWidth&quot;: 0 } }">
					<?php foreach($settings['projects'] as $item):?>
						<div class="grid-sizer"></div>
						<div class="grid-item grid-size-50">
						<?php if($item['style'] == '1'):?>
							<div class="bz-portfolio-item1">
								<div class="bz-portfolio-img">
									<img src="<?php echo esc_url($item['project-img']['url']);?>" alt="">
								</div>
								<div class="bz-portfolio-text position-relative headline">
								<span class="portfolio-cat"><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['category']);?></a></span>
									<h3><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['title']);?></a></h3>
									<?php if(!empty($settings['arrow']['url'])):?>
									<a class="read_more" href="<?php echo esc_url($item['link']['url']);?>"><img src="<?php echo esc_url($settings['arrow']['url']);?>" alt=""></a>
									<?php endif;?>
								</div>
							</div>
							<?php else:?>
							<div class="bz-portfolio-item2">
								<div class="bz-portfolio-img-text d-flex align-items-center">
									<div class="bz-portfolio-img">
										<img src="<?php echo esc_url($item['project-img']['url']);?>" alt="">
									</div>
									<div class="bz-portfolio-text position-relative pera-content headline">
									<span class="portfolio-cat"><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['category']);?></a></span>
										<h3><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['title']);?></a></h3>
										<p><?php echo wp_kses( $item['excerpt'], true );?></p>
										<?php if(!empty($settings['arrow']['url'])):?>
									<a class="read_more" href="<?php echo esc_url($item['link']['url']);?>"><img src="<?php echo esc_url($settings['arrow']['url']);?>" alt=""></a>
									<?php endif;?>
									</div>
								</div>
							</div>
						<?php endif;?>
						</div>						
					<?php endforeach;?>
					
				</div>
			</div>
			<?php if(!empty($settings['view_btn'])):?>
				<div class="bz-portfolio-more-btn d-flex justify-content-center">
					<div class="bz-btn-2 text-uppercase">
						<a href="<?php echo esc_url($settings['view_btn_link']['url']);?>"><?php echo esc_html($settings['view_btn']);?> <i class="fas fa-long-arrow-right"></i></a>
					</div>
				</div>
			<?php endif;?>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Projects_Masonary_Filter() );