<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Project_Info extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-project-info-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Info', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Project Info Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'info', [
				'label' => esc_html__( 'Info', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'projects_info',
			[
				'label' => esc_html__( 'Add Project Info', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'Section-BG-Color',
            [
                'label' => esc_html__( 'Section BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-project-details-feature' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-project-details-feature h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bz-project-details-feature h3',
            ]
        );
        /*Project*/
        $this->add_control(
            '--Project-Style-Heading--',
            [
                'label' => esc_html__( 'Project Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Project-Title-Color',
            [
                'label' => esc_html__( 'Project Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-project-details-feature .feature-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Project-Title-Typography',
                'label' => 'Project Title Typography',
                'selector' => '{{WRAPPER}} .bz-project-details-feature .feature-list li',
            ]
        );
        $this->add_control(
            'Project-Info-Color',
            [
                'label' => esc_html__( 'Project Info Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-project-details-feature .feature-list li span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Project-Info-Typography',
                'label' => 'Project Info Typography',
                'selector' => '{{WRAPPER}} .bz-project-details-feature .feature-list li span',
            ]
        );

        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="bz-project-details-feature headline">
        <h3><?php echo wp_kses( $settings['title'], true );?></h3>
        <div class="feature-list ul-li-block">
            <ul>
                <?php foreach($settings['projects_info'] as $item):?>
                <li><?php echo esc_html($item['title']);?> <span><?php echo esc_html($item['info']);?></span></li>
                <?php endforeach;?>
            </ul>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Project_Info() );