<?php

/**
 * Elementor Single Widget
 * @package radios Extension
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Projects_Filter extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bzx-project-filter-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Project Filter', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bz_filter_opt',
			[
				'label' => esc_html__( 'Projects Filter Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'all_text', [
				'label' => esc_html__( 'All Text', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'filter_id', [
				'label' => esc_html__( 'Filter Id', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

        $repeater->add_control(
			'filter_name', [
				'label' => esc_html__( 'Filter Name', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        
		$this->add_control(
			'projects_filter',
			[
				'label' => esc_html__( 'Add Filter Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ filter_name }}}',
			]
		);

		$repeater = new \Elementor\Repeater();
		
        $repeater->add_control(
			'filter_id', [
				'label' => esc_html__( 'Filter Id', 'bizex-tools' ),				
				'placeholder' => esc_html__( 'Add Id Multiple Id heare with a space EX:1 2 3', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

        $repeater->add_control(
			'category', [
				'label' => esc_html__( 'Category', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'project-img', [
				'label' => esc_html__( 'Project Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'include' => [],
				'default' => 'large',
			]
		);
        $repeater->add_control(
			'title', [
				'label' => esc_html__( 'Project Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'link', [
				'label' => esc_html__( 'Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        
		$this->add_control(
			'projects',
			[
				'label' => esc_html__( 'Add Project Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->add_control(
			'arrow', [
				'label' => esc_html__( 'Arrow', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /*Tab-Title*/
        $this->add_control(
            '--Tab-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Tab Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Tab-Title-Color',
            [
                'label' => esc_html__( 'Tab Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-portfolio-hos-tab-btn button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Tab-Title-Typography',
                'label' => 'Tab Title Typography',
                'selector' => '{{WRAPPER}} .bz-portfolio-hos-tab-btn button',
            ]
        );
        /*Project*/
        $this->add_control(
            '--Project-Style-Heading--',
            [
                'label' => esc_html__( 'Project Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Project-Category-Color',
            [
                'label' => esc_html__( 'Project Category Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text .portfolio-cat' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Project-Category-Typography',
                'label' => 'Project Category Typography',
                'selector' => '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text .portfolio-cat',
            ]
        );
        $this->add_control(
            'Project-Title-Color',
            [
                'label' => esc_html__( 'Project Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Project-Title-Typography',
                'label' => 'Project Title Typography',
                'selector' => '{{WRAPPER}} .bz-portfolio-item1 .bz-portfolio-text h3',
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>
    <section id="bz-project-feed" class="bz-project-feed-section">
        <div class="container">
            <div class="bz-portfolio-hos-tab-btn text-center button-group">
                <button class="filter-button is-checked" data-filter="*"><?php echo esc_html($settings['all_text']);?></button>
				<?php foreach($settings['projects_filter'] as $item):?>
                	<button class="filter-button" data-filter=".<?php echo esc_attr($item['filter_id']);?>"><?php echo esc_html($item['filter_name']);?></button>
				<?php endforeach;?>
            </div>
            <div class="bz-portfolio-filter-feed-tab">
                <div class="filtr-container-area grid clearfix" data-isotope="{ &quot;masonry&quot;: { &quot;columnWidth&quot;: 0 } }">
					<div class="grid-sizer"></div>
                    <?php foreach($settings['projects'] as $item):?>
                    <div class="grid-item grid-size-50  <?php echo esc_attr($item['filter_id']);?>" data-category="<?php echo esc_attr($item['filter_id']);?>">
                        <div class="bz-portfolio-item1">
                            <div class="bz-portfolio-img">
                                <img src="<?php echo esc_url($item['project-img']['url']);?>" alt="">
                            </div>
                            <div class="bz-portfolio-text position-relative headline">
                                <span class="portfolio-cat"><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['category']);?></a></span>
                                <h3><a href="<?php echo esc_url($item['link']['url']);?>"><?php echo esc_html($item['title']);?></a></h3>
								<?php if(!empty($settings['arrow']['url'])):?>
                               	<a class="read_more" href="<?php echo esc_url($item['link']['url']);?>"><img src="<?php echo esc_url($settings['arrow']['url']);?>" alt=""></a>
								<?php endif;?>
                            </div>
                        </div>
                    </div>
					<?php endforeach;?>
                </div>
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Projects_Filter() );