<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Pricing_Table extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-pricing-table-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Table', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Pricing Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'is_populer',
			[
				'label' => esc_html__( 'Populer Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'bizex-tools' ),
				'label_off' => esc_html__( 'Hide', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		$this->add_control(
			'price_icon', [
				'label' => esc_html__( 'Pricing Icon', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'include' => [],
				'default' => 'large',
			]
		);
		$this->add_control(
			'animation_delay', [
				'label' => esc_html__( 'Animation Delay', 'bizex-tools' ),
				'placeholder' => esc_html__( '0ms', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'price', [
				'label' => esc_html__( 'Price', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'preiod', [
				'label' => esc_html__( 'Preiod', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'saving_text', [
				'label' => esc_html__( 'Saving Text', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);

		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-pricing-item .bz-price-tag' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bz-pricing-item .bz-price-tag',
            ]
        );

        /*Price*/
        $this->add_control(
            '--Price-Style-Heading--',
            [
                'label' => esc_html__( 'Price Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Price-Color',
            [
                'label' => esc_html__( 'Price Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-pricing-item .bz-price-value h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Price-Typography',
                'label' => 'Price Typography',
                'selector' => '{{WRAPPER}} .bz-pricing-item .bz-price-value h3',
            ]
        );
        $this->add_control(
            'Preiod-Color',
            [
                'label' => esc_html__( 'Preiod Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-pricing-item .bz-price-value h3 sub' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Preiod-Typography',
                'label' => 'Preiod Typography',
                'selector' => '{{WRAPPER}} .bz-pricing-item .bz-price-value h3 sub',
            ]
        );

        /*Saving text*/
        $this->add_control(
            '--Saving-Style-Heading--',
            [
                'label' => esc_html__( 'Saving Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Saving-Color',
            [
                'label' => esc_html__( 'Saving Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-pricing-item .bz-price-value p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Saving-Typography',
                'label' => 'Saving Typography',
                'selector' => '{{WRAPPER}} .bz-pricing-item .bz-price-value p',
            ]
        );

        /*Description*/
        $this->add_control(
            '--Description-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-pricing-item .bz-price-list-item li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bz-pricing-item .bz-price-list-item li',
            ]
        );

        /*Button*/
        $this->add_control(
            '--Button-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-pricing-item.central-price .bz-price-plan-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-pricing-item.central-price .bz-price-plan-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-pricing-item.central-price .bz-price-plan-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div class="wow fadeInUp" data-wow-delay="<?php echo esc_url($animation_delay);?>" data-wow-duration="1500ms">
        <div class="bz-pricing-item text-center position-relative <?php if($is_populer == 'yes'){ echo esc_attr('central-price');}?>">
            <div class="bz-price-tag position-absolute">
            <?php echo wp_kses( $title, true );?>
            </div>
            <?php if(!empty($settings['price_icon']['url'])):?>
            <div class="bz-price-icon">
                <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'price_icon' );?>
            </div>
            <?php endif;?>
            <div class="bz-price-value headline pera-content">
                <h3><?php echo esc_html($price);?> <sub><?php echo esc_html($preiod);?></sub></h3>
                <p><?php echo wp_kses( $saving_text, true );?></p>
            </div>
            <?php if(!empty($btn_label)):?>
            <div class="bz-price-plan-btn text-uppercase text-center">
                <a href="<?php echo esc_url($btn_link['url']);?>"><?php echo esc_html($btn_label);?></a>
            </div>
            <?php endif;?>
            <div class="bz-price-list-item ul-li-block">
                <?php echo wp_kses( $description, true );?>
            </div>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Pricing_Table() );