<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Pricing_Tab extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-pricing-tab-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Pricing Tab', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Pricing Tabs', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Is Active', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'content_title', [
				'label' => esc_html__( 'Content Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'content_desc', [
				'label' => esc_html__( 'Content Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'content_pricing', [
				'label' => esc_html__( 'Price', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'period', [
				'label' => esc_html__( 'Period', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Pricing Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'pricing_img', [
				'label' => esc_html__( 'Pricing Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'pricing_shape', [
				'label' => esc_html__( 'Pricing Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'plans',
			[
				'label' => esc_html__( 'Add Plans Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Sub title*/
        $this->add_control(
            '--Sub-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Sub Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );

        /*title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title h2',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'Pricing_style_1',
            [
                'label' => __( 'Pricing Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Pricing Plan*/
        $this->add_control(
            '--Pricing-Plan-Style-Heading--',
            [
                'label' => esc_html__( 'Pricing Plan Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Pricing-Plan-Title-Color',
            [
                'label' => esc_html__( 'Pricing Plan Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-btn-area button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Pricing-Plan-Title-Typography',
                'label' => 'Pricing Plan Typography',
                'selector' => '{{WRAPPER}} .bizx-pricing-btn-area button',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Pricing-Plan-Bottom-Border-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-pricing-btn-area button:after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Pricing Plan Bottom Border Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Pricing Content style*/
        $this->add_control(
            '--Pricing-Plan-Content-Style-Heading--',
            [
                'label' => esc_html__( 'Content Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Pricing-Plan-Content--Color',
            [
                'label' => esc_html__( 'Content Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-price-text .bizx-pricing-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Pricing-Plan-Content--Typography',
                'label' => 'Content Typography',
                'selector' => '{{WRAPPER}} .bizx-pricing-price-text .bizx-pricing-text h3',
            ]
        );
        $this->add_control(
            'Pricing-Plan-Content-Description--Color',
            [
                'label' => esc_html__( 'Content Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-price-text .bizx-pricing-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Pricing-Plan-Content-Description--Typography',
                'label' => 'Content Description Typography',
                'selector' => '{{WRAPPER}} .bizx-pricing-price-text .bizx-pricing-text span',
            ]
        );
        $this->add_control(
            'Pricing-Plan-Content-Description-BG--Color',
            [
                'label' => esc_html__( 'Content Description BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-price-text .bizx-pricing-text span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Price style*/
        $this->add_control(
            '--Price-Style-Heading--',
            [
                'label' => esc_html__( 'Price Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Price--Color',
            [
                'label' => esc_html__( 'Price Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-price-text .bizx-price-pricing h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Price--Typography',
                'label' => 'Price Typography',
                'selector' => '{{WRAPPER}} .bizx-pricing-price-text .bizx-price-pricing h4',
            ]
        );

        /*Period style*/
        $this->add_control(
            '--Period-Style-Heading--',
            [
                'label' => esc_html__( 'Period Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Period-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-pricing-price-text .bizx-price-pricing span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Period Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Period--Typography',
                'label' => 'Period Typography',
                'selector' => '{{WRAPPER}} .bizx-pricing-price-text .bizx-price-pricing span',
            ]
        );

        /*Pricing List style*/
        $this->add_control(
            '--Pricing-Plan-List-Style-Heading--',
            [
                'label' => esc_html__( 'Pricing Plan List Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Pricing-Plan-List--Color',
            [
                'label' => esc_html__( 'Pricing Plan List Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-list-item-area li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Pricing-Plan-List--Typography',
                'label' => 'Pricing Plan List Typography',
                'selector' => '{{WRAPPER}} .bizx-pricing-list-item-area li',
            ]
        );

        $this->add_control(
            'Pricing-Plan-List-Style--Color',
            [
                'label' => esc_html__( 'Pricing List Style Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-pricing-list-item-area li:before' => 'background-color: {{VALUE}}',
                    '{{WRAPPER}} .bizx-pricing-list-item-area ul:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
		
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bizx-pricing" class="bizx-pricing-section">
        <div class="bizx-pricing-tilte-text-btn-area d-flex justify-content-end">
            <div class="bizx-pricing-tilte-text">
                <div class="bizx-section-title pera-content bzx-headline wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
					<?php if(!empty($settings['subtitle'])):?>
						<div class="subtitle">
							<?php echo wp_kses($settings['subtitle'], true);?>
						</div>
					<?php endif;?>
                    <h2><?php echo wp_kses($settings['title'], true);?></h2>
                </div>
                <div class="bizx-pricing-btn-area">
                    <ul class="nav nav-tabs" id="myTab1" role="tablist">
						<?php foreach($settings['plans'] as $item):?>
							<li class="nav-item" role="presentation">
								<button class="nav-link <?php if($item['is_active'] == 'yes'){ echo esc_attr('active');}?>"  data-bs-toggle="tab" data-bs-target="#price<?php echo esc_attr($item['_id']);?>" type="button" role="tab" >
									<?php echo wp_kses($item['title'], true);?>
								</button>
							</li>
                       <?php endforeach;?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="tab-content" id="myTabContent2">
			<?php foreach($settings['plans'] as $item):?>
            <div class="tab-pane animated fadeInUp <?php if($item['is_active'] == 'yes'){ echo esc_attr('show active');}?>" id="price<?php echo esc_attr($item['_id']);?>" role="tabpanel" aria-labelledby="home-tab">
                <div class="bizx-pricing-tab-item-content d-flex">
                    <div class="bizx-pricing-img-price">
                        <div class="bizx-pricing-img position-relative">
							<?php if(!empty($item['pricing_img']['url'])):?>
                            	<img src="<?php echo esc_url($item['pricing_img']['url']);?>" alt="">
							<?php endif;?>
							<?php if(!empty($item['pricing_shape']['url'])):?>
                            	<span class="price-bg position-absolute"><img src="<?php echo esc_url($item['pricing_shape']['url']);?>" alt=""></span>
							<?php endif;?>
                        </div>
                        <div class="bizx-pricing-price-text d-flex align-items-center justify-content-between">
                            <div class="bizx-pricing-text bzx-headline">
                                <h3><?php echo esc_html($item['content_title']);?></h3>
                                <span><?php echo wp_kses($item['content_desc'], true);?></span>
                            </div>
                            <div class="bizx-price-pricing bzx-headline">
                                <h4><?php echo esc_html($item['content_pricing']);?></h4>
                                <span><?php echo esc_html($item['period']);?></span>
                            </div>
                        </div>
                    </div>
                    <div class="bizx-pricing-list-item-area ul-li-block">
                        <?php echo wp_kses($item['description'], true);?>
						<?php if(!empty($item['btn_label'])):?>
                        <div class="bizx-btn text-uppercase">
                            <a href="<?php echo esc_url($item['btn_link']['url']);?>"><?php echo esc_html($item['btn_label']);?></a>
                        </div>
						<?php endif;?>
                    </div>

                </div>
            </div>
            <?php endforeach;?>
        </div>
	</section>	
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Pricing_Tab() );