<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Portfolio_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-portfolio-slide-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Portfolio Slide', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Testimonial Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'list_description', [
				'label' => esc_html__( 'List Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'project_img', [
				'label' => esc_html__( 'Project Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'include' => [],
				'default' => 'full',
			]
		);
		
		
		$repeater->add_control(
			'project_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'projects',
			[
				'label' => esc_html__( 'Add Project Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        /*Sub title*/
        $this->add_control(
            '--Sub-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Sub Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-what-happen-text-area .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-what-happen-text-area .bizx-section-title h2',
            ]
        );
        $this->add_control(
            'List-Title-Color',
            [
                'label' => esc_html__( 'List Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-what-happen-text-area .bizx-introduction-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'List-Title-Typography',
                'label' => 'List Title Typography',
                'selector' => '{{WRAPPER}} .bizx-what-happen-text-area .bizx-introduction-list li',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'List-Title-Icon-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-introduction-list li:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('List Title Icon BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();
        $this->start_controls_section(
            'Portfolio_style_1',
            [
                'label' => __( 'Portfolio Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Image-Right-BG-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-what-happen-img-item .wh-link a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Image Right BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Link-Circle-BG-Color',
            [
                'label' => esc_html__( 'Link Circle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-what-happen-img-item .wh-link a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Link-Icon-Color',
            [
                'label' => esc_html__( 'Link Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-what-happen-img-item .wh-link a i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div class="bizx-what-happen-content">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="bizx-what-happen-img-wrapper">
                    <?php foreach($settings['projects'] as $item):?>
                    <div class="bizx-what-happen-img-item position-relative wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1000ms">
                        <div class="inner-img position-relative">
                            <div class="bizx-img-shade wow"></div>
                            <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'project_img' );?>
                        </div>
                        <div class="wh-link">
                            <a href="<?php echo esc_url($item['project_link']['url']);?>"><i class="far fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <?php endforeach;?>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="bizx-what-happen-text-area position-relative">
                    <div class="bizx-section-title pera-content bzx-headline wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php if(!empty($settings['sub_title'])):?>
                        <div class="subtitle">
                            <?php echo wp_kses($settings['sub_title'], true);?>
                        </div>
                        <?php endif;?>
                        <h2><?php echo wp_kses($settings['title'], true);?></h2>
                    </div>
                    <div class="bizx-introduction-list ul-li-block wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
                        <?php echo wp_kses($settings['list_description'], true);?>
                    </div>
                    <?php if(!empty($settings['btn_label'])):?>
                        <div class="bizx-btn text-uppercase wow fadeInUp" data-wow-delay="450ms" data-wow-duration="1000ms">
                            <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?></a>
                        </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Portfolio_Slider() );