<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Post_Tw extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bizex-post-tw-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog List', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_projects_option',
			[
				'label' => esc_html__( 'News Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Project Order', 'bizex-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'bizex-tools' ),
					'DESC' => esc_html__( 'Descending', 'bizex-tools' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'bizex-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
		
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'bizex-tools' ),
				'options'     => bizex_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'bizex-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'bizex-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
        $this->add_control(
			'more_button', [
				'label' => esc_html__( 'Blog More Button', 'bizex-tools' ),
				'default' => esc_html__( 'Read More', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-blog-item-2 .bz-blog-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bz-blog-item-2 .bz-blog-text h3',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-blog-item-2 .bz-blog-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bz-blog-item-2 .bz-blog-text p',
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-blog-item-2 .bz-blog-text .read_more' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-blog-item-2 .bz-blog-text .read_more',
            ]
        );

        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		
        $args = array(
			'post_type'           => 'post',
			'posts_per_page'      => !empty( $settings['post_per_page'] ) ? $settings['post_per_page'] : 1,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'order'               => $settings['post_order'],
		);
		if( ! empty($settings['post_categories'] ) ){
			$args['category_name'] = implode(',', $settings['post_categories']);
		}
		
		$query = new \WP_Query( $args );
    
    ?>
    <div class="bz-blog-top-content-2">
        <div class="row">
            <?php
                if ( $query->have_posts() ) {
                $iten_number = 0;
                while ( $query->have_posts() ) {
                $query->the_post();
                    $bizex_thumb_size = 'bizex-img-size-4';
                    $iten_number++;
                    $title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
                    $excerpt = wp_trim_words( get_the_excerpt(), $settings['excerpt_length'], '' );
            ?>
            <div class="col-lg-6">
                <div class="bz-blog-item-2 d-flex align-items-center">
                    <div class="bz-blog-img">
                        <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), $bizex_thumb_size )?>" alt="">
                    </div>
                    <div class="bz-blog-text headline pera-content">
                        <h3><a href="<?php the_permalink()?>"><?php echo $title;?></a></h3>
                        <p><?php echo $excerpt;?></p>
                        <a class="read_more" href="<?php the_permalink()?>"><?php echo esc_html($settings['more_button']);?> <i class="far fa-long-arrow-right"></i></a>
                    </div>
                </div>
            </div>
            <?php } wp_reset_query(); } ?>
        </div>
    </div>

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Post_Tw() );