<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Post_Thr extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bizex-post-3-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog Three', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_projects_option',
			[
				'label' => esc_html__( 'News Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Project Order', 'bizex-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'bizex-tools' ),
					'DESC' => esc_html__( 'Descending', 'bizex-tools' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'bizex-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
		
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'bizex-tools' ),
				'options'     => bizex_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'bizex-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'bizex-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
        $this->add_control(
			'more_button', [
				'label' => esc_html__( 'Blog More Button', 'bizex-tools' ),
				'default' => esc_html__( 'Read More', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /*Meta-Style*/
        $this->add_control(
            '--Meta-Style-Heading--',
            [
                'label' => esc_html__( 'Meta Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Meta-Icon-Color',
            [
                'label' => esc_html__( 'Meta Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-blog-item .blog-meta a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Meta-Title-Color',
            [
                'label' => esc_html__( 'Meta Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-blog-item .blog-meta a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Meta-Title-Typography',
                'label' => 'Meta Title Typography',
                'selector' => '{{WRAPPER}} .bzx-blog-item .blog-meta a',
            ]
        );


        /*Title-Style*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-blog-item .blog-title h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bzx-blog-item .blog-title h3',
            ]
        );
        $this->add_control(
            'Title-Hover-Color',
            [
                'label' => esc_html__( 'Title Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-blog-item .blog-title h3:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        /*Button-Style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-blog-item .read_more' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bzx-blog-item .read_more',
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-blog-item .read_more:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		
        $args = array(
			'post_type'           => 'post',
			'posts_per_page'      => !empty( $settings['post_per_page'] ) ? $settings['post_per_page'] : 1,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'order'               => $settings['post_order'],
		);
		if( ! empty($settings['post_categories'] ) ){
			$args['category_name'] = implode(',', $settings['post_categories']);
		}
		
		$query = new \WP_Query( $args );
    
    ?>
    <div class="container">
        <div class="bzx-blog-content">
            <div class="bzx-blog-slider-area">
                <div class="bzx-blog-slider">
                    <?php
                        if ( $query->have_posts() ) {
                        $iten_number = 0;
                        while ( $query->have_posts() ) {
                        $query->the_post();
                            $bizex_thumb_size = 'full';
                            $iten_number++;
                            $title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
                            $excerpt = wp_trim_words( get_the_excerpt(), $settings['excerpt_length'], '' );
                    ?>
                    <div class="bzx-slider-item">
                        <div class="bzx-blog-item">
                            <?php if(has_post_thumbnail()):?>
                            <div class="blog-img">
                                <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(), $bizex_thumb_size )?>" alt="">
                            </div>
                            <?php endif;?>
                            <div class="blog-text bzx-headline">
                                <div class="blog-meta">
                                    <a href="#"><i class="fal fa-user"></i> <?php the_author()?></a>
                                    <a href="#"><i class="fal fa-tag"></i> Business</a>
                                </div>
                                <div class="blog-title">
                                    <h3><a href="<?php the_permalink();?>"><?php echo $title;?></a></h3>
                                </div>
                                <?php if(!empty($settings['more_button'])):?>
                                    <a class="read_more text-uppercase" href="<?php the_permalink();?>"><?php echo esc_html($settings['more_button']);?> <i class="far fa-long-arrow-right"></i></a>
                                <?php endif;?>
                            </div>
                        </div>
                    </div>
                    <?php } wp_reset_query(); } ?>
                </div>
            </div>
            <div class="bzx-blog-carousel bzx-carousel-btn text-uppercase d-flex justify-content-end">
                <div class="carousel_nav text-center position-relative">
                    <button type="button" class="bzx_blg_left_arrow text-uppercase"><i class="far fa-long-arrow-left"></i></button>
                    <button type="button" class="bzx_blg_right_arrow text-uppercase"><i class="far fa-long-arrow-right"></i></button>
                </div>
            </div>
        </div>
    </div>

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Post_Thr() );