<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Post_Six extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-blog2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog Six', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_projects_option',
			[
				'label' => esc_html__( 'News Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
            'query_type',
            [
                'label' => __('Query type', 'cando'),
                'type' => Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'category' => __('Category', 'cando'),
                    'individual' => __('Individual', 'cando'),
                ],
            ]
        );

        $this->add_control(
            'cat_query',
            [
                'label' => __('Category', 'cando'),
                'type' => Controls_Manager::SELECT2,
                'options' => ae_drop_cat('category'),
                'multiple' => true,
                'label_block' => true,
                'condition' => [
                    'query_type' => 'category',
                ],
                'default' => __( 'cando', 'cando' ),
            ]
        );

        $this->add_control(
            'id_query',
            [
                'label' => __('Posts', 'cando'),
                'type' => Controls_Manager::SELECT2,
                'options' => ae_drop_posts('post'),
                'multiple' => true,
                'label_block' => true,
                'condition' => [
                    'query_type' => 'individual',
                ],
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'cando'),
                'type' => Controls_Manager::NUMBER,
                'default' => 3,
            ]
        );
        $this->add_control(
            'rma',
            [
                'label' => __('Read More', 'cando'),
                'type' => Controls_Manager::NUMBER,
                'default' => __('Read More', 'cando'),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-img-text-inner-2 .blog-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-text h3',
            ]
        );
        $this->add_control(
            'post_tiiitle_color',
            [
                'label' => __( 'Info Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-img-text-inner-2 .blog-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihii',
                'label' => __( 'Info Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-text p',
            ]
        );
        $this->add_control(
            'post_tiiitlffe_color',
            [
                'label' => __( 'Button Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-img-text-inner-2 .blog-text .more-btn' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihiibb',
                'label' => __( 'Button Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-text .more-btn',
            ]
        );
        $this->add_control(
            'date_color',
            [
                'label' => __( 'Meta Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-img-text-inner-2 .blog-meta a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihd',
                'label' => __( 'Meta Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-meta a',
            ]
        );
        $this->add_control(
            'aut_color',
            [
                'label' => __( 'Icon Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-img-text-inner-2 .blog-meta a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'post_ovsaerlaya',
            [
                'label' => __( 'Meta BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlayssaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-meta',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Image Border', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-img',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'ssborder',
                'label' => __( 'Image Shadow', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-img',
            ]
        );
        $this->add_control(
            'post_overlaya',
            [
                'label' => __( 'Post BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .blog-img-text-inner-2 .blog-text, {{WRAPPER}} .blog-img-text-inner-2 .blog-img-wrap:before',
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
        
        $settings = $this->get_settings_for_display();

        $per_page = $settings['posts_per_page'];
        $cat = $settings['cat_query'];
        $id = $settings['id_query'];


        if($settings['query_type'] == 'category'){
            $query_args = array(
                'post_type' => 'post',
                'posts_per_page' => $per_page,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $cat,
                    ) ,
                ) ,
            );
        }

        if($settings['query_type'] == 'individual'){
            $query_args = array(
                'post_type' => 'post',
                'posts_per_page' => $per_page,
                'post__in' =>$id,
                'orderby' => 'post__in'
            );
        }
        $wp_query = new \WP_Query($query_args);

    echo '<!-- Start of blog section
	============================================= -->
	<section id="blog-2" class="blog-section-2">			
			<div class="blog-content-2">
				<div class="row">';
                    if( $wp_query->have_posts() ) {
                        while( $wp_query->have_posts() ) {
                            $wp_query->the_post();
            echo '<div class="col-lg-4">
						<div class="blog-img-text-inner-2">
							<div class="blog-img-wrap position-relative">
								<div class="blog-img">';
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('full');
                            }
                            echo '</div>
							</div>
							<div class="blog-meta text-center">
								<a href="'.get_author_posts_url('ID').'"><i class="fas fa-user"></i> '.get_the_author_meta('display_name').'</a>
								<a href="'.get_month_link(get_the_date('Y'), get_the_date('m')).'"><i class="fas fa-calendar-alt"></i>  ' . get_the_time('j, M Y') . '</a>
							</div>
							<div class="blog-text headline pera-content">
								<h3><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h3>
								<p>' . get_the_excerpt() . '</p>
								<a class="more-btn" href="' . get_the_permalink() . '">'.$settings['rma'].' <i class="fas fa-angle-double-right"></i></a>
							</div>
						</div>
					</div>';
                    }
                    wp_reset_postdata();
                   }
                echo'</div>
			</div>
	</section>
<!-- End of blog. section
	============================================= -->';
    }
    protected function _content_template() {}

    protected function content_template() {}

   public function render_plain_content( $instance = [] ) {}
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Post_Six() );