<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Post_Four extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bizex-post-4-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog Four', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_projects_option',
			[
				'label' => esc_html__( 'News Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Project Order', 'bizex-tools' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'ASC',
				'options'   => [
					'ASC'  => esc_html__( 'Ascending', 'bizex-tools' ),
					'DESC' => esc_html__( 'Descending', 'bizex-tools' ),
				],
			]
		);
		
		$this->add_control(
			'post_per_page',
			[
				'label'   => __( 'Posts Per Page', 'bizex-tools' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 5,
			]
		);
		
		$this->add_control(
			'post_categories',
			[
				'type'        => Controls_Manager::SELECT2,
				'label'       => esc_html__( 'Select Categories', 'bizex-tools' ),
				'options'     => bizex_blog_category(),
				'label_block' => true,
				'multiple'    => true,
			]
		);
		$this->add_control(
			'title_length',
			[
				'label'     => __( 'Title Length', 'bizex-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
		$this->add_control(
			'excerpt_length',
			[
				'label'     => __( 'Excerpt Length', 'bizex-tools' ),
				'type'      => Controls_Manager::NUMBER,
				'step'      => 1,
				'default'   => 20,
			]
		);
        $this->add_control(
			'more_button', [
				'label' => esc_html__( 'Blog More Button', 'bizex-tools' ),
				'default' => esc_html__( 'Read More', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'Category-Color',
            [
                'label' => esc_html__( 'Category Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-blog-item .bizx-blog-category a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Category-Typography',
                'label' => 'Category Typography',
                'selector' => '{{WRAPPER}} .bizx-blog-item .bizx-blog-category a',
            ]
        );
        $this->add_control(
            'Category-BG-Color',
            [
                'label' => esc_html__( 'Category BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-blog-item .bizx-blog-category a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-blog-item h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bizx-blog-item h3',
            ]
        );
        $this->add_control(
            'Meta-Color',
            [
                'label' => esc_html__( 'Meta Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-blog-item .bizx-blog-meta a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Meta-Typography',
                'label' => 'Meta Typography',
                'selector' => '{{WRAPPER}} .bizx-blog-item .bizx-blog-meta a',
            ]
        );
        $this->add_control(
            'Author-Color',
            [
                'label' => esc_html__( 'Author Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-blog-item .bizx-blog-author .author-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Author-Typography',
                'label' => 'Author Typography',
                'selector' => '{{WRAPPER}} .bizx-blog-item .bizx-blog-author .author-text',
            ]
        );
        $this->add_control(
            'Box-Border-Color',
            [
                'label' => esc_html__( 'Box Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-blog-item' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Box-Hover-BG-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-blog-item:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Box Hover BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();		
        $args = array(
			'post_type'           => 'post',
			'posts_per_page'      => !empty( $settings['post_per_page'] ) ? $settings['post_per_page'] : 1,
			'post_status'         => 'publish',
			'ignore_sticky_posts' => 1,
			'order'               => $settings['post_order'],
		);
		if( ! empty($settings['post_categories'] ) ){
			$args['category_name'] = implode(',', $settings['post_categories']);
		}
		
		$query = new \WP_Query( $args );
    ?>
    <div class="bizx-blog-feed-content">
		<div class="row">
			<?php
				if ( $query->have_posts() ) {
				$iten_number = 0;
				while ( $query->have_posts() ) {
				$query->the_post();
					$bizex_thumb_size = 'full';
					$iten_number++;
					$title = wp_trim_words( get_the_title(), $settings['title_length'], '' );
					$excerpt = wp_trim_words( get_the_excerpt(), $settings['excerpt_length'], '' );
					$categories = get_the_category();

					
			?>
			<div class="col-lg-4 wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
				<div class="bizx-blog-item position-relative bzx-headline">
					<div class="bizx-blog-category">
						<a href="#">
							<?php if ( ! empty( $categories ) ) {
								echo esc_html( $categories[0]->name );	
							} ?>
						</a>
					</div>
					<h3><a href="#"><?php echo $title;?></a></h3>
					<div class="bizx-blog-meta">
						<a href="#"><i class="fas fa-calendar-alt"></i> <?php echo date(get_option('date_format')); ?></a>
						<a href="#"><i class="fas fa-comments"></i>  <?php echo esc_attr(get_comments_number());?> <?php esc_html_e( 'Comments', 'bizex-tools' );?></a>
					</div>
					<div class="bizx-blog-author d-flex align-items-center">
						<div class="author-img">
							<?php bizex_post_author_avatars(60);?>
						</div>
						<div class="author-text">
							<?php the_author()?>
						</div>
					</div>
				</div>
			</div>
			<?php } wp_reset_query(); } ?>
		</div>
	</div>	
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Post_Four() );