<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Post_Five extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-blog1';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Blog Five', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_projects_option',
			[
				'label' => esc_html__( 'News Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
            'query_type',
            [
                'label' => __('Query type', 'cando'),
                'type' => Controls_Manager::SELECT,
                'default' => 'category',
                'options' => [
                    'category' => __('Category', 'cando'),
                    'individual' => __('Individual', 'cando'),
                ],
            ]
        );

        $this->add_control(
            'cat_query',
            [
                'label' => __('Category', 'cando'),
                'type' => Controls_Manager::SELECT2,
                'options' => ae_drop_cat('category'),
                'multiple' => true,
                'label_block' => true,
                'condition' => [
                    'query_type' => 'category',
                ],
                'default' => __( 'cando', 'cando' ),
            ]
        );

        $this->add_control(
            'id_query',
            [
                'label' => __('Posts', 'cando'),
                'type' => Controls_Manager::SELECT2,
                'options' => ae_drop_posts('post'),
                'multiple' => true,
                'label_block' => true,
                'condition' => [
                    'query_type' => 'individual',
                ],
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'cando'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text h3',
            ]
        );
        $this->add_control(
            'post_title_h_color',
            [
                'label' => __( 'Title Hover Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text h3:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'date_color',
            [
                'label' => __( 'Date Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text .blog-feed-meta .date-meta' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihd',
                'label' => __( 'Date Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text .blog-feed-meta .date-meta',
            ]
        );
        $this->add_control(
            'aut_color',
            [
                'label' => __( 'Author Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text .blog-feed-meta .author-meta' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihdau',
                'label' => __( 'Author Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text .blog-feed-meta .author-meta',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => __( 'Border', 'cando' ),
                'selector' => '{{WRAPPER}} .blog-feed-img-text-1 .blog-feed-text',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Row Gap', 'cando' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .blog-feed-img-text-1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
		
		$this->end_controls_section();
	}


	protected function render() {
        $settings = $this->get_settings_for_display();

        $per_page = $settings['posts_per_page'];
        $cat = $settings['cat_query'];
        $id = $settings['id_query'];


        if($settings['query_type'] == 'category'){
            $query_args = array(
                'post_type' => 'post',
                'posts_per_page' => $per_page,
                'tax_query' => array(
                    array(
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $cat,
                    ) ,
                ) ,
            );
        }

        if($settings['query_type'] == 'individual'){
            $query_args = array(
                'post_type' => 'post',
                'posts_per_page' => $per_page,
                'post__in' =>$id,
                'orderby' => 'post__in'
            );
        }
        $wp_query = new \WP_Query($query_args);

    echo '<!-- Start of blog section
	============================================= -->
	<section id="blog-1" class="blog-section-1 position-relative">
        <div class="blog-content-1">			
            <div class="can-blog-feed-item">';
                    if( $wp_query->have_posts() ) {
                        while( $wp_query->have_posts() ) {
                            $wp_query->the_post();
            echo '<div class="blog-feed-img-text-1">
                        <div class="blog-feed-img float-left">';
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('full');
                            }
                            echo '</div>
                        <div class="blog-feed-text headline pera-content">
                            <div class="blog-feed-meta">
                                <a class="date-meta" href="'.get_month_link(get_the_date('Y'), get_the_date('m')).'"> ' . get_the_time('j M Y') . '</a>
                                <a class="author-meta" href="'.get_author_posts_url('ID').'">By: '.get_the_author_meta('display_name').'</a>
                            </div>
                            <h3><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h3>
                        </div>
                    </div>';
                    }
                    wp_reset_postdata();
                   }
                echo'</div>
        </div>
	</section>
<!-- End of blog section
	============================================= -->
';
    }
    protected function _content_template() {}

    protected function content_template() {}

   public function render_plain_content( $instance = [] ) {}
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Post_Five() );