<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Icon_Box extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-iconbox1';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Info Box', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Info Box Content', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'member_name',
            [
                'label' => __( 'Title', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Dedicated Team', 'cando' ),
            ]
        );
        $repeater->add_control(
            'member_info',
            [
                'label' => __( 'Info', 'cando' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __( 'Lorem Ipsum texted the printing and typesetting
                                    industry. Lorem hasn’t been the
                                    industrys standard.', 'cando' ),
            ]
        );
        $repeater->add_control(
            'team_url',
            [
                'label' => __( 'Link', 'cando' ),
                'type' => \Elementor\Controls_Manager::URL,
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $repeater->add_control(
            'member_photo', [
                'label' => __( 'Photo', 'cando' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'member_list',
            [
                'label' => __( 'Feature List', 'cando' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'member_name' => __( 'Dedicated Team', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Dedicated Team', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Dedicated Team', 'cando' ),
                    ],
                    [
                        'member_name' => __( 'Dedicated Team', 'cando' ),
                    ],
                ],
                'title_field' => '{{{ member_name }}}',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-innerbox .feature-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_fonts',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .feature-innerbox .feature-text h3',
            ]
        );
        $this->add_control(
            'inf_color',
            [
                'label' => __( 'Info Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .feature-innerbox .feature-text p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'inf_fonts',
                'label' => __( 'Info Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .feature-innerbox .feature-text p',
            ]
        );
        $this->add_control(
            'social_bg',
            [
                'label' => __( 'Box BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_socials_bg',
                'label' => __( 'Team Social BG', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .feature-innerbox',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_socials_bgh',
                'label' => __( 'Team Social BG', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .feature-innerbox:hover',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_socials_bghb',
                'label' => __( 'Team Social BG', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .feature-innerbox:after',
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
        $settings = $this->get_settings_for_display();
        echo '<!-- Start of Feature section
        ============================================= -->
        <section id="feature" class="feature-section">
                <div class="feature-content">
                    <div class="row">';
            if ( $settings['member_list'] ) {
                foreach ($settings['member_list'] as $members) {
                echo'<div class="col-lg-3 col-md-6">
                            <div class="feature-innerbox position-relative text-center">
                                <div class="feature-icon">
                                     '.get_that_image( $members['member_photo'] ).'
                                </div>
                                <div class="feature-text headline pera-content">
                                    <h3><a '.get_that_link($members['team_url']).'>'.$members['member_name'].'</a></h3>
                                    <p>'.$members['member_info'].'</p>
                                </div>
                            </div>
                        </div>';
                        }
                    }
                echo'</div>
                </div>
        </section>		
    <!-- End of Feature section
        ============================================= -->';  
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Icon_Box() );