<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Home_Contact extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-home-contact-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Home Contact', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Contact Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape3', [
				'label' => esc_html__( 'Shape 3', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'cta_img', [
				'label' => esc_html__( 'CTA Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'arrow_img', [
				'label' => esc_html__( 'Arrow Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'phone_no', [
				'label' => esc_html__( 'Phone Number', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'email_id', [
				'label' => esc_html__( 'Email Id', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'location_title', [
				'label' => esc_html__( 'Location Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'address', [
				'label' => esc_html__( 'Address', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Subtitle-Color',
            [
                'label' => esc_html__( 'Section Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-section-title .sub-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Subtitle-Typography',
                'label' => 'Section Subtitle Typography',
                'selector' => '{{WRAPPER}} .bz-section-title .sub-title',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bz-section-title h2',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Special-Title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-section-title h2 span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Contact Info*/
        $this->add_control(
            '--Contact-Info-Style-Heading--',
            [
                'label' => esc_html__( 'Contact-Info Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Contact-Info-Color',
            [
                'label' => esc_html__( 'Contact Info Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-contact-img-cta .bz-cta-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Contact-Info-Typography',
                'label' => 'Contact Info Typography',
                'selector' => '{{WRAPPER}} .bz-contact-img-cta .bz-cta-text span',
            ]
        );

        /*Office-Info*/
        $this->add_control(
            '--Office-Info-Style-Heading--',
            [
                'label' => esc_html__( 'Office Info Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Location-Title-Color',
            [
                'label' => esc_html__( 'Location Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-contact-btn-cta .bz-contact-location h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Location-Title-Typography',
                'label' => 'Location Title Typography',
                'selector' => '{{WRAPPER}} .bz-contact-btn-cta .bz-contact-location h3',
            ]
        );
        $this->add_control(
            'Address-Color',
            [
                'label' => esc_html__( 'Address Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-contact-btn-cta .bz-contact-location p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Address-Typography',
                'label' => 'Address Typography',
                'selector' => '{{WRAPPER}} .bz-contact-btn-cta .bz-contact-location p',
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Icon-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Icon Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bz-contact" class="bz-contact-section position-relative">
        <?php if(!empty($shape['url'])):?>
		    <span class="bz-contact-shape1 position-absolute"><img src="<?php echo esc_url($shape['url']);?>" alt=""></span> 
        <?php endif;?>
        <?php if(!empty($shape2['url'])):?>
		    <span class="bz-contact-shape2 position-absolute"><img src="<?php echo esc_url($shape2['url']);?>" alt=""></span> 
        <?php endif;?>
        <?php if(!empty($shape3['url'])):?>
		    <span class="bz-contact-shape3 position-absolute"><img src="<?php echo esc_url($shape3['url']);?>" alt=""></span> 
        <?php endif;?>
		<div class="container">
			<div class="bz-contact-content  d-flex justify-content-end">
				<div class="bz-contact-text-wrap">
					<div class="bz-section-title pera-content headline">
                        <?php if(!empty($sub_title)):?>
                            <span class="sub-title text-uppercase"><?php echo wp_kses( $sub_title, true );?></span>
                        <?php endif;?>
						<h2><?php echo wp_kses( $title, true );?></h2>
					</div>
					<div class="bz-contact-img-cta d-flex flex-wrap align-items-center">
                        <?php if(!empty($cta_img['url'])):?>
						<div class="bz-cta-img">
							<img src="<?php echo esc_url($cta_img['url']);?>" alt="">
						</div>
                        <?php endif;?>
						<div class="bz-cta-text">
							<span>
                            <?php if(!empty($arrow_img['url'])):?>
                                <img src="<?php echo esc_url($arrow_img['url']);?>" alt=""> 
                                <?php endif;?>
                                <?php echo wp_kses( $phone_no, true );?></span>
							<span><?php echo wp_kses( $email_id, true );?></span>	
						</div>
					</div>
					<div class="bz-contact-btn-cta d-flex align-items-center">
						<div class="bz-contact-location headline pera-content">
							<h3><?php echo esc_html($location_title);?> <i class="far fa-arrow-down"></i></h3>
							<p><?php echo wp_kses( $address, true );?></p>
						</div>
                        <?php if(!empty($btn_label)):?>
                            <div class="bz-btn-2 text-uppercase">
                                <a href="<?php echo esc_url($btn_link['url']);?>"><?php echo wp_kses( $btn_label, true );?> <i class="fas fa-long-arrow-right"></i></a>
                            </div>
                        <?php endif;?>
					</div>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Home_Contact() );