<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Hero_Slider extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-hero-slider-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Hero SLider', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Slider Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'video_label', [
				'label' => esc_html__( 'Video Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'video_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        $repeater->add_control(
			'shape3', [
				'label' => esc_html__( 'Shape 3', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'sliders',
			[
				'label' => esc_html__( 'Add Slide Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        

		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Subtitle-Color',
            [
                'label' => esc_html__( 'Section Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-main-slide-item-2 .slide-slug' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Subtitle-Typography',
                'label' => 'Section Subtitle Typography',
                'selector' => '{{WRAPPER}} .bz-main-slide-item-2 .slide-slug',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-main-slide-item-2 h1' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bz-main-slide-item-2 h1',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Special-Title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-main-slide-item-2 h1 span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Icon-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Icon Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        /*Play Button*/
        $this->add_control(
            '--Play-Button-Style-Heading--',
            [
                'label' => esc_html__( 'Play Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Play-Button-Icon-Color',
            [
                'label' => esc_html__( 'Play Button Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Play-Button-Border-Color',
            [
                'label' => esc_html__( 'Play Button Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a i' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Play-Button-Title-Color',
            [
                'label' => esc_html__( 'Play Button Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Play-Button-Title-Typography',
                'label' => 'Play Button Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a span',
            ]
        );

        /*Slider arrow*/
        $this->add_control(
            '--Slider-Arrow-Style-Heading--',
            [
                'label' => esc_html__( 'Slider Arrow Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Slider-Arrow-Hover-BG-Color',
            [
                'label' => esc_html__( 'Slider Arrow Hover BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-slider-content .carousel_nav button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();

	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bz-slider-2" class="bz-slider-section-2">
		<div class="bz-slider-content position-relative">
            <div class="bz-main-slider-2">
                <?php foreach($sliders as $item):?>
                <div class="bz-main-slide-item-2 headline pera-content position-relative">
                    <div class="container">
                        <div class="slide-slug text-uppercase">
                            <?php echo wp_kses( $item['subtitle'], true );?>
                        </div>
                        <h1>
                            <?php echo wp_kses( $item['title'], true );?>
                        </h1>
                        <div class="bz-slider-btn-grp">
                            <div class="bz-about-play-btn d-flex align-items-center">
                                <?php if(!empty($item['btn_label'])):?>
                                    <div class="bz-btn-2 text-uppercase">
                                        <a href="<?php echo esc_url($item['btn_link']['url']);?>"><?php echo esc_html($item['btn_label']);?> <i class="fas fa-long-arrow-right"></i></a>
                                    </div>
                                <?php endif;?>
                                <?php if(!empty($item['video_label'])):?>
                                <div class="bz-play-btn">
                                    <a class="video_box" href="<?php echo esc_url($item['video_link']['url']);?>">
                                        <i class="fas fa-play"></i>
                                        <span><?php echo esc_html($item['video_label']);?></span>
                                    </a>
                                </div>
                                <?php endif;?>
                            </div>
                        </div>
                    </div>
                    <?php if(!empty($item['shape']['url'])):?>
                        <div class="bz-slider-shape1 position-absolute slider-shape">
                            <img src="<?php echo esc_url($item['shape']['url']);?>" alt="">
                        </div>
                    <?php endif;?>
                    <?php if(!empty($item['shape2']['url'])):?>
                        <div class="bz-slider-shape2 position-absolute slider-shape">
                            <img src="<?php echo esc_url($item['shape2']['url']);?>" alt="">
                        </div>
                    <?php endif;?>
                    <?php if(!empty($item['shape3']['url'])):?>
                    <div class="bz-slider-shape3 position-absolute slider-shape">
                        <img src="<?php echo esc_url($item['shape3']['url']);?>" alt="">
                    </div>
                    <?php endif;?>
                </div>
                <?php endforeach;?>
            </div>
            <div class="carousel_nav text-center position-absolute">
                <button type="button" class="bz_main_left_arrow text-uppercase"><i class="far fa-long-arrow-left"></i></button>
                <button type="button" class="bz_main_right_arrow text-uppercase"><i class="far fa-long-arrow-right"></i></button>
            </div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Hero_Slider() );