<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Faq extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-faq-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FAQ', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_faq_option',
			[
				'label' => esc_html__( 'FAQ Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'faq_img', [
				'label' => esc_html__( 'Faq Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'faq_img2', [
				'label' => esc_html__( 'Faq Image 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Item', 'bizex-tools' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$repeater->add_control(
			'faq_title', [
				'label' => esc_html__( 'Faq Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'accordions',
			[
				'label' => esc_html__( 'Add Accordion Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ faq_title }}}',
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Subtitle-Color',
            [
                'label' => esc_html__( 'Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => esc_html__( 'Sub Title Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .bzx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Subtitle-BG-Color',
            [
                'label' => esc_html__( 'Subtitle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__( 'Title Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .bzx-section-title h2',
            ]
        );

        /*Description*/
        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pera-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-typography',
                'label' => esc_html__( 'Description Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .pera-content p',
            ]
        );

        /*FAQ*/
        $this->add_control(
            '--FAQ-Style-Heading--',
            [
                'label' => esc_html__( 'FAQ Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'FAQ-Title-Color',
            [
                'label' => esc_html__( 'FAQ Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-faq-accordion .accordion-button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'FAQ-Title-typography',
                'label' => esc_html__( 'FAQ Title Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .bzx-faq-accordion .accordion-button',
            ]
        );
        $this->add_control(
            'FAQ-Description-Color',
            [
                'label' => esc_html__( 'FAQ Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-faq-accordion .accordion-body' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'FAQ-Description-typography',
                'label' => esc_html__( 'FAQ Description Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .bzx-faq-accordion .accordion-body',
            ]
        );
        $this->add_control(
            'FAQ-Icon-Color',
            [
                'label' => esc_html__( 'FAQ Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-faq-accordion .accordion-button:not(.collapsed)::after' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-faq" class="bzx-faq-section position-relative">
        <div class="bzx-faq-content position-relative">
            <div class="bzx-about-img-wrap d-flex position-absolute">
                <?php if(!empty($settings['faq_img']['url'])):?>
                    <div class="bzx-about-img-1" data-parallax='{"y" : -100}'>
                        <img src="<?php echo esc_url($settings['faq_img']['url']);?>" alt="">
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['faq_img2']['url'])):?>
                    <div class="bzx-about-img-2" data-parallax='{"y" : 100}'>
                        <img src="<?php echo esc_url($settings['faq_img2']['url']);?>" alt="">
                    </div>
                <?php endif;?>
            </div>
            <div class="container">
                <div class="bzx-faq-accordio-area">
                    <div class="bzx-section-title bzx-headline pera-content position-relative">
                        <?php if(!empty($settings['sub_title'])):?>
                        <div class="subtitle text-uppercase wow fadeInDown" data-wow-delay="300ms" data-wow-duration="1500ms">
                            <?php echo esc_html($settings['sub_title']);?>
                        </div> 
                        <?php endif;?>
                        <?php if(!empty($settings['title'])):?>
                            <h2 data-splitting><?php echo wp_kses($settings['title'], true);?> </h2>
                        <?php endif;?>
                        <?php if(!empty($settings['description'])):?>
                        <p class="wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms"><?php echo wp_kses($settings['description'], true);?></p>
                        <?php endif;?>
                    </div>
                    <div class="bzx-faq-accordion"> 
                        <div class="accordion" id="accordionExample2">
                            <?php foreach($settings['accordions'] as $item):?>
								<div class="accordion-item headline-2 pera-content wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
									<h2 class="accordion-header" id="headingOne2<?php echo esc_attr($item['_id']);?>">
										<button class="accordion-button <?php if($item['is_active'] != 'yes'):?> collapsed <?php endif;?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne2<?php echo esc_attr($item['_id']);?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr($item['_id']);?>">
											<?php echo wp_kses($item['faq_title'], true)?>
										</button>
									</h2>
									<div id="collapseOne2<?php echo esc_attr($item['_id']);?>" class="accordion-collapse collapse <?php if($item['is_active'] == 'yes'):?> show <?php endif;?>" aria-labelledby="headingOne2<?php echo esc_attr($item['_id']);?>" data-bs-parent="#accordionExample2">
										<div class="accordion-body">
										<?php echo wp_kses($item['description'], true)?>
										</div>
									</div>
								</div>
                            <?php endforeach;?>                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Faq() );