<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Faq_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-faq-two-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'FAQ Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'Bizex_Faq_Two_option',
			[
				'label' => esc_html__( 'FAQ Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();

		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Faq Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'counter', [
				'label' => esc_html__( 'Counter', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'circle_progress',
			[
				'label' => esc_html__( 'Add Progress Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Item', 'bizex-tools' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$repeater->add_control(
			'faq_title', [
				'label' => esc_html__( 'Faq Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$this->add_control(
			'accordions',
			[
				'label' => esc_html__( 'Add Accordion Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ faq_title }}}',
			]
		);
       
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'Container-BG--Color',
            [
                'label' => esc_html__( 'Container BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-faq-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Sub title*/
        $this->add_control(
            '--Sub-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Sub Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-faq-content .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-faq-content .bizx-section-title h2',
            ]
        );

        /*Description*/
        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Description--Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title p',
            ]
        );

        /* Counter style*/
        $this->add_control(
            '--Counter-Style-Heading--',
            [
                'label' => esc_html__( 'Counter Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Number-Color',
            [
                'label' => esc_html__( 'Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-circle-progress-item .count-box' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Number-Typography',
                'label' => 'Number Typography',
                'selector' => '{{WRAPPER}} .bizx-circle-progress-item .count-box',
            ]
        );
        $this->add_control(
            'Progressbar-Title-Color',
            [
                'label' => esc_html__( 'Progressbar Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-circle-progress-item h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Progressbar-Title-Typography',
                'label' => 'Progressbar Title Typography',
                'selector' => '{{WRAPPER}} .bizx-circle-progress-item h3',
            ]
        );
        $this->add_control(
            'Progressbar-Circle-Color',
            [
                'label' => esc_html__( 'Progressbar Circle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'FAQ_style_1',
            [
                'label' => __( 'FAQ Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'FAQ-Title-Color',
            [
                'label' => esc_html__( 'FAQ Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-faq-feed-accordion .accordion-header button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'FAQ-Title-Typography',
                'label' => 'FAQ Title Typography',
                'selector' => '{{WRAPPER}} .bizx-faq-feed-accordion .accordion-header button',
            ]
        );
        $this->add_control(
            'FAQ-Info-Color',
            [
                'label' => esc_html__( 'FAQ Info Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-faq-feed-accordion .accordion-body' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'FAQ-Info-Typography',
                'label' => 'FAQ Info Typography',
                'selector' => '{{WRAPPER}} .bizx-faq-feed-accordion .accordion-body',
            ]
        );
        $this->add_control(
            'FAQ-Border-Color',
            [
                'label' => esc_html__( 'FAQ Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-faq-feed-accordion .accordion-item' => 'border-bottom-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'FAQ-Icon-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-faq-feed-accordion .accordion-button::after',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('FAQ Icon Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div class="bizx-faq-content">
        <div class="row">
            <div class="col-lg-6">
                <div class="bizx-faq-text-progress">
                    <div class="bizx-section-title pera-content bzx-headline wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
                        <?php if(!empty($settings['sub_title'])):?>
                        <div class="subtitle">
                            <?php echo wp_kses($settings['sub_title'], true);?>
                        </div>
                        <?php endif;?>
                        <h2><?php echo wp_kses($settings['title'], true);?></h2>
                        <p><?php echo wp_kses($settings['description'], true);?></p>
                    </div>
                    <div class="bizx-faq-circle-progress d-flex position-relative justify-content-between">
                        <?php foreach($settings['circle_progress'] as $item):?>
                        <div class="bizx-circle-progress-item wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
                            <div class="counter-boxed text-center  bzx-headline">
                                <div class="graph-outer text-center  position-relative">
                                    <input type="text" class="dial" data-fgColor="<?php echo esc_attr($settings['Progressbar-Circle-Color']); ?>" data-bgColor="#fff" data-width="115" data-height="115"   value="<?php echo esc_attr($item['counter']);?>" >
                                    <div class="inner-text count-box"><span class="count-text" data-stop="<?php echo esc_attr($item['counter']);?>" data-speed="4500"></span>%</div>
                                </div>
                                <h3><?php echo esc_html($item['title']);?></h3>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="bizx-faq-feed-accordion">
                    <div class="accordion" id="accordionExample2">

                        <?php foreach($settings['accordions'] as $item):?>
                        
                        <div class="accordion-item bzx-headline pera-content wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1500ms">
                            <h2 class="accordion-header" id="headingTwo2<?php echo esc_attr($item['_id']);?>">
                                <button class="accordion-button <?php if($item['is_active'] != 'yes'){echo esc_attr('collapsed');}?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo2<?php echo esc_attr($item['_id']);?>" aria-expanded="false" aria-controls="collapseTwo2<?php echo esc_attr($item['_id']);?>">
                                    <span><?php echo wp_kses($item['faq_title'], true)?></span>
                                </button>
                            </h2>
                            <div id="collapseTwo2<?php echo esc_attr($item['_id']);?>" class="accordion-collapse collapse <?php if($item['is_active'] == 'yes'){echo esc_attr('show');}?>" aria-labelledby="headingTwo2<?php echo esc_attr($item['_id']);?>" data-bs-parent="#accordionExample2<?php echo esc_attr($item['_id']);?>">
                                <div class="accordion-body">
                                    <?php echo wp_kses($item['description'], true)?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach;?>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Faq_Two() );