<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Cta extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-cta-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'CTA', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Counter Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'cta_bg', [
				'label' => esc_html__( 'CTA Background Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'cta_img', [
				'label' => esc_html__( 'CTA Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'readmore_btn', [
				'label' => esc_html__( 'Readmore Button', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'readmore_link', [
				'label' => esc_html__( 'Readmore Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-footer-cta-content .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__( 'Title Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-footer-cta-content .bzx-section-title h2',
			]
		);

        $this->add_control(
            'Text-Color',
            [
                'label' => esc_html__( 'Text Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-footer-cta-content .bzx-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
                'label' => esc_html__( 'Text Typography', 'bizex-tools' ),
				'selector' => '{{WRAPPER}} .bzx-footer-cta-content .bzx-section-title p',
			]
		);

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'bt_typography',
                'label' => esc_html__( 'Btn Typography', 'bizex-tools' ),
                'selector' => '{{WRAPPER}} .bzx-btn a',
            ]
        );
        $this->add_control(
            'Button-BG-Color',
            [
                'label' => esc_html__( 'Button BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-BG-Color',
            [
                'label' => esc_html__( 'Button Hover BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Hover-Icon-BG-Color',
            [
                'label' => esc_html__( 'Button Hover Icon BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a:hover i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-footer-cta" class="bzx-footer-cta-section position-relative">
		<div class="container">
			<div class="bzx-footer-cta-content position-relative" style="background-image:url(<?php echo esc_url($settings['cta_bg']['url']);?>)">
                <?php if(!empty($settings['cta_img']['url'])):?>
				    <span class="bzx-cta-img position-absolute wow slideInRight" data-wow-delay="200ms" data-wow-duration="1500ms"><img src="<?php echo esc_url($settings['cta_img']['url']);?>" alt=""></span>
                <?php endif;?>
				<div class="bzx-blog-text-area">
					<div class="bzx-section-title bzx-headline pera-content position-relative">
						<h2 data-splitting><?php echo wp_kses($settings['title'], true);?></h2>
						<p><?php echo wp_kses($settings['description'], true);?></p>
					</div>
                    <?php if(!empty($settings['readmore_btn'])):?>
                        <div class="bzx-btn text-uppercase">
                            <a href="<?php echo esc_url($settings['readmore_link']['url']);?>"><?php echo esc_html($settings['readmore_btn']);?> <i class="fal fa-long-arrow-right"></i></a>
                        </div>
                    <?php endif;?>
				</div>
			</div>
		</div>
	</section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Cta() );