<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Cta_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-cta-two-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'CTA Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Counter Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label_two', [
				'label' => esc_html__( 'Button Two', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link_two', [
				'label' => esc_html__( 'Button Two Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'rating_title', [
				'label' => esc_html__( 'Rating Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'total_rating', [
				'label' => esc_html__( 'Total Rating', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'rating_gallery',
			[
				'label' => esc_html__( 'Rating Image', 'bizex-tools' ),
				'type' => Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);
		$this->add_control(
			'cta_form', [
				'label' => esc_html__( 'Cta Form Shortcode', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'cta_bg', [
				'label' => esc_html__( 'Cta Background', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title h2',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Section-Special-Title-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title h2 span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Section-Description-Color',
            [
                'label' => esc_html__( 'Section Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Description-Typography',
                'label' => 'Section Description Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title p',
            ]
        );
        $this->add_control(
            '--Button-Style--OneOption--',
            [
                'label' => esc_html__( 'Button Style One', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt1');
        $this->start_controls_tab(
            'tab_controls_normal1',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color1',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography1',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color1',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover1',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position1',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_control(
            '--Button-Style--Two-Option--',
            [
                'label' => esc_html__( 'Button Style Two', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt2');
        $this->start_controls_tab(
            'tab_controls_normal2',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color2',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn-about-grp .bizx-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography2',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn-about-grp .bizx-btn-2 a',
            ]
        );
        $this->add_control(
            'Button-Border-Color2',
            [
                'label' => esc_html__( 'Button Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn-about-grp .bizx-btn-2 a' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover2',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-hover-Background-Color2',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn-about-grp .bizx-btn-2 a:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Hover-Border-Color2',
            [
                'label' => esc_html__( 'Button Hover Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn-about-grp .bizx-btn-2 a:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            '--Ratting-Title-Style--Option--',
            [
                'label' => esc_html__( 'Ratting Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Ratting-Title-Color',
            [
                'label' => esc_html__( 'Ratting Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-five-star-review p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Ratting-Title-Typography',
                'label' => 'Ratting Title Typography',
                'selector' => '{{WRAPPER}} .bizx-five-star-review p',
            ]
        );

        $this->add_control(
            '--Ratting-Number-Style--Two-Option--',
            [
                'label' => esc_html__( 'Ratting Number Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Ratting-Number-Color',
            [
                'label' => esc_html__( 'Ratting Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-review-number' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Ratting-Number-Typography',
                'label' => 'Ratting Number Typography',
                'selector' => '{{WRAPPER}} .bizx-review-number',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'ratting-number-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-review-number',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Ratting Number Background', 'bizex-tools'),
                    ],
                ],
            ]
        );

        $this->add_control(
            '--Form-Button-Style--Two-Option--',
            [
                'label' => esc_html__( 'Form Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt-F');
        $this->start_controls_tab(
            'tab_controls_normal-F',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color-F',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-cta-form-area button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography-F',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-cta-form-area button',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color-F',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-cta-form-area button',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover-F',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position-F',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-cta-form-area button:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>

    <div class="bizx-cta-content">
        <div class="row">
            <div class="col-lg-7">
                <div class="bizx-cta-text-wrapper">
                    <div class="bizx-section-title bzx-headline pera-content wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
						<?php if(!empty($settings['subtitle'])):?>
							<div class="subtitle">
								<?php echo wp_kses($settings['subtitle'], true);?>
							</div>
						<?php endif;?>
                        <h2><?php echo wp_kses($settings['title'], true);?></h2>
                        <p><?php echo wp_kses($settings['description'], true);?></p>
                    </div>
                    <div class="bizx-btn-about-grp d-flex align-items-center wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
						<?php if(!empty($settings['btn_label'])):?>
							<div class="bizx-btn text-uppercase">
								<a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?></a>
							</div>
						<?php endif;?>
						<?php if(!empty($settings['btn_label_two'])):?>
							<div class="bizx-btn-2 text-uppercase">
								<a href="<?php echo esc_url($settings['btn_link_two']['url']);?>"><?php echo esc_html($settings['btn_label']);?></a>
							</div>
						<?php endif;?>
                    </div>
                    <div class="bizx-five-star-review pera-content wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1000ms">
						<?php if(!empty($settings['rating_title'])):?>
                        	<p><?php echo wp_kses($settings['rating_title'], true);?></p>
						<?php endif;?>
                        <div class="bizx-five-star-review-img-number d-flex">
							<?php if(!empty($settings['rating_gallery'])):?>
                            <div class="bizx-five-star-review-img ul-li">
                                <ul>
									<?php foreach($settings['rating_gallery'] as $item):?>
                                    	<li><img src="<?php echo esc_url($item['url']);?>" alt=""></li>
									<?php endforeach;?>
                                </ul>
                            </div>
							<?php endif;?>
							<?php if(!empty($settings['total_rating'])):?>
                            <div class="bizx-review-number d-flex align-items-center justify-content-center">
                                <?php echo wp_kses($settings['total_rating'], true);?>
                            </div>
							<?php endif;?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 wow fadeInRight" data-wow-delay="300ms" data-wow-duration="1000ms">
                <div class="bizx-cta-form-area" <?php if(!empty($settings['cta_bg']['url'])):?>data-background="<?php echo esc_url($settings['cta_bg']['url']);?>" <?php endif;?>>
                    <?php echo do_shortcode($settings['cta_form'])?>
                </div>
            </div>
        </div>
    </div>

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Cta_Two() );