<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Cta_Three extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-cta-three-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'CTA Three', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Counter Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_label_two', [
				'label' => esc_html__( 'Button Two', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link_two', [
				'label' => esc_html__( 'Button Two Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'rating_title', [
				'label' => esc_html__( 'Rating Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'total_rating', [
				'label' => esc_html__( 'Total Rating', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'rating_gallery',
			[
				'label' => esc_html__( 'Rating Image', 'bizex-tools' ),
				'type' => Controls_Manager::GALLERY,
				'show_label' => false,
				'default' => [],
			]
		);
		
		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'Content-BG-Color',
            [
                'label' => esc_html__( 'Content-BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizex-footer-cta-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title h2',
            ]
        );

        /*Info*/
        $this->add_control(
            '--Info-Style-Heading--',
            [
                'label' => esc_html__( 'Info Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Info-Color',
            [
                'label' => esc_html__( 'Info Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Info-Typography',
                'label' => 'Info Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title p',
            ]
        );

        /*Rating*/
        $this->add_control(
            '--Rating-Style-Heading--',
            [
                'label' => esc_html__( 'Rating Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Rating-Title-Color',
            [
                'label' => esc_html__( 'Rating Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizex-footer-cta-review p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Rating-Title-Typography',
                'label' => 'Rating Title Typography',
                'selector' => '{{WRAPPER}} .bizex-footer-cta-review p',
            ]
        );
        $this->add_control(
            'Total-Rating-Title-Color',
            [
                'label' => esc_html__( 'Total Rating Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizex-footer-cta-review p span' => 'color: {{VALUE}}',
                ],
            ]
        );
		$this->end_controls_section();

        $this->start_controls_section(
            'Button_1_style_1',
            [
                'label' => __( 'Button 1 Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizex-footer-cta-btn-grp .bizx-btn:first-child a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizex-footer-cta-btn-grp .bizx-btn:first-child a',
            ]
        );
        $this->add_control(
            'Button-BG-Color',
            [
                'label' => esc_html__( 'Button BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizex-footer-cta-btn-grp .bizx-btn:first-child a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Hover-BG-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizex-footer-cta-btn-grp .bizx-btn:first-child a:before',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Hover BG Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'Button-2-Style',
            [
                'label' => __( 'Button 2 Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs('tpcnt2');
        $this->start_controls_tab(
            'tab_controls_normal2',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color2',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography2',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color2',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover2',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position2',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>

    <div class="bizex-footer-cta-content">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="bizx-footer-cta-text position-relative">
                    <div class="bizx-section-title pera-content bzx-headline">
                        <h2><?php echo wp_kses($settings['title'], true);?></h2>
                        <p><?php echo wp_kses($settings['description'], true);?></p>
                    </div>
                    <div class="bizex-footer-cta-review d-flex pera-content align-items-start">
                        <?php if(!empty($settings['rating_gallery'])):?>
                        <div class="bizx-five-star-review-img ul-li">
                            <ul>
                                <?php foreach($settings['rating_gallery'] as $item):?>
                                    <li><img src="<?php echo esc_url($item['url']);?>" alt=""></li>
                                <?php endforeach;?>
                            </ul>
                        </div>
                        <?php endif;?>
                        
                        <p><?php if(!empty($settings['rating_title'])):?><?php echo wp_kses($settings['rating_title'], true);?>
                        <?php endif;?>
                        <?php if(!empty($settings['total_rating'])):?>
                            <?php echo wp_kses($settings['total_rating'], true);?>
                        </p>
                        <?php endif;?>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="bizex-footer-cta-btn-grp text-center">
                    <?php if(!empty($settings['btn_label'])):?>
                    <div class="bizx-btn text-uppercase">
                        <a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?></a>
                    </div>
                    <?php endif;?>
                    <?php if(!empty($settings['btn_label_two'])):?>
                    <div class="bizx-btn text-uppercase">
                        <a href="<?php echo esc_url($settings['btn_link_two']['url']);?>"><?php echo esc_html($settings['btn_label_two']);?></a>
                    </div>
                    <?php endif;?>
                </div>
            </div>
        </div>
    </div>

    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Cta_Three() );