<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_CaseStudy extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-cases2';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Cases', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Case Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'project_img', [
				'label' => esc_html__( 'Project Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'category', [
				'label' => esc_html__( 'Category', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'project_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'casess',
			[
				'label' => esc_html__( 'Add Project Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
       
		$this->end_controls_section();
        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-img-text .portfolio-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .portfolio-img-text .portfolio-text h3',
            ]
        );
        $this->add_control(
            'post_c_color',
            [
                'label' => __( 'Category Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-img-text .portfolio-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihc',
                'label' => __( 'Category Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .portfolio-img-text .portfolio-text span',
            ]
        );
        $this->add_control(
            'post_overlaya',
            [
                'label' => __( 'Overlay', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [ 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .portfolio-img-text:before',
            ]
        );
        $this->add_control(
            'post_cb_color',
            [
                'label' => __( 'Arrow Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-content-slider .owl-nav .owl-next:hover, {{WRAPPER}} .portfolio-content-slider .owl-nav .owl-prev:hover' => 'color: {{VALUE}}; border-color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
        $settings = $this->get_settings_for_display();

        echo '<!-- Start of portfolio section
            ============================================= -->
            <section id="portfolio" class="portfolio-section">
                <div class="portfolio-content-wrap">
                    <div class="portfolio-content-slider">';
                            foreach($settings['casess'] as $item){
                            echo '<div class="portfolio-img-text position-relative">
                            <div class="portfolio-img">
                            <img src="'.esc_url($item['project_img']['url']).'">
                            ';
                                echo '</div>
                            <div class="portfolio-text text-center headline">
                                <h3><a href="' . $item['project_link']['url'] . '">' . $item['title'] . '</a></h3>
                                <span class="port-cat text-uppercase">'.$item['category'].'</span>
                            </div>
                        </div>';
                         }
                echo'</div>
                </div>
            </section>		
        <!-- End of portfolio section
            ============================================= -->';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_CaseStudy() );