<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_CaseStudy_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'cando-cases';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Cases Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Case Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'project_img', [
				'label' => esc_html__( 'Project Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'category', [
				'label' => esc_html__( 'Category', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'project_link',
			[
				'label' => esc_html__( 'Link To Single Page', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'casess',
			[
				'label' => esc_html__( 'Add Project Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

        $this->add_control(
            'load_more',
            [
                'label' => __('Load More', 'cando'),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'Learn More', 'cando' ),
            ]
        );
        $this->add_control(
            'load_more_link',
            [
                'label' => __('Load More Link', 'cando'),
                'type' => Controls_Manager::URL,
            ]
        );
        $this->add_control(
            'btn_icon',
            [
                'label' => __( 'Button Icon', 'cando' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-right',
                    'library' => 'brand',
                ],
            ]
        );
       
		$this->end_controls_section();
        
        $this->start_controls_section(
            'content_sty',
            [
                'label' => __( 'Style', 'cando' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'post_title_color',
            [
                'label' => __( 'Title Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .case-study-item-area .item-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttih',
                'label' => __( 'Title Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .case-study-item-area .item-text h3',
            ]
        );
        $this->add_control(
            'post_c_color',
            [
                'label' => __( 'Category Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .case-study-item-area .item-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihc',
                'label' => __( 'Category Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .case-study-item-area .item-text span',
            ]
        );
        $this->add_control(
            'post_aoverlaya',
            [
                'label' => __( 'Case Icon BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'icon_c',
            [
                'label' => __( 'Icon Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .case-study-item-area .item-text .case-item-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'posta_overlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [ 'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .case-study-item-area .item-text .case-item-icon',
            ]
        );
        $this->add_control(
            'post_overlaya',
            [
                'label' => __( 'Case BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_overlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .case-study-item-area:before',
            ]
        );
        $this->add_control(
            'post_boverlaya',
            [
                'label' => __( 'Button BG', 'cando' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $this->add_control(
            'post_cb_color',
            [
                'label' => __( 'Button Color', 'cando' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'ttihcb',
                'label' => __( 'Button Typography', 'cando' ),
                'selector' => '{{WRAPPER}} .service-btn a',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'post_boverlayaa',
                'label' => __( 'Overlay', 'cando' ),
                'types' => [  'classic', 'gradient' ],
                'show_label' => true,
                'selector' => '{{WRAPPER}} .service-btn a',
            ]
        );
        $this->add_responsive_control(
            'content_margin',
            [
                'label' => __( 'Row Gap', 'cando' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .case-study-item-wrapper .grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
	}


	protected function render() {
        $settings = $this->get_settings_for_display();

        echo '<!-- Start of case  section
	============================================= -->
	<section id="case-page-area" class="case-page-area-section">
			<div class="case-study-content-wrapper">
				<div class="case-study-item-wrapper grid">
					<div class="grid-sizer"></div>';
                    foreach($settings['casess'] as $item){
                    echo '<div class="grid-item case-study-item  grid-33">
						<div class="case-study-item-area position-relative">
							<div class="item-img">
                                <img src="'.esc_url($item['project_img']['url']).'">
                            ';
                                    echo '</div>
							<div class="item-text text-center headline">
								<div class="case-item-icon">
									<a href="' . $item['project_link']['url']  . '">';\Elementor\Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']); echo'</a>
								</div>
								<h3><a href="' . $item['project_link']['url']  . '">' . $item['title'] . '</a></h3>
								<span class="text-uppercase">'.$item['category'].'</span>
							</div>
						</div>
					</div>';
                       }
                echo'</div>';
                    echo '<div class="service-btn d-flex justify-content-center">
					    <a href="'.$settings['load_more_link']['url'].'">'.$settings['load_more'].'</a>
				    </div>';
			echo '</div>
	</section>	
<!-- End of case  section
	============================================= -->	';
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_CaseStudy_Two() );