<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Button extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-btn-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Button', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Button Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'default' => esc_html__( 'Bizex Button', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label' => esc_html__( 'Link', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => esc_html__( 'https://your-link.com', 'bizex-tools' ),
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
					// 'custom_attributes' => '',
				],
				'label_block' => true,
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Arrow-Color',
            [
                'label' => esc_html__( 'Button Hover Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();
        if ( ! empty( $settings['btn_link']['url'] ) ) {
			$this->add_link_attributes( 'btn_link', $settings['btn_link'] );
		}
    ?>
    <div class="bz-btn text-uppercase">
        <a <?php echo $this->get_render_attribute_string( 'btn_link' ); ?>><?php echo esc_html($settings['btn_label']);?> <i class="fas fa-long-arrow-right"></i></a>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Button() );