<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Business_Tab extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-business-tab-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Business Tab', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Business Tabs', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Is Active', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'plans',
			[
				'label' => esc_html__( 'Add Plans Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        
		$this->end_controls_section();
		
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bizx-pricing" class="bizx-pricing-section">
        <div class="bizx-pricing-tilte-text-btn-area d-flex justify-content-end">
            <div class="bizx-pricing-tilte-text">
                <div class="bizx-section-title pera-content bzx-headline wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
                    <div class="subtitle">
                        <?php echo wp_kses($settings['subtitle'], true);?>
                    </div>
                    <h2><?php echo wp_kses($settings['title'], true);?></h2>
                </div>
                <div class="bizx-pricing-btn-area">
                    <ul class="nav nav-tabs" id="myTab1" role="tablist">

                        <li class="nav-item" role="presentation">
                            <button class="nav-link active"  data-bs-toggle="tab" data-bs-target="#price1" type="button" role="tab" >
                                Medium Plans
                            </button>
                        </li>
                       
                    </ul>
                </div>
            </div>
        </div>
        <div class="tab-content" id="myTabContent2">

            <div class="tab-pane animated fadeInUp show active" id="price1" role="tabpanel" aria-labelledby="home-tab">
                <div class="bizx-pricing-tab-item-content d-flex">
                    <div class="bizx-pricing-img-price">
                        <div class="bizx-pricing-img position-relative">
                            <img src="assets/img/about/pr1.png" alt="">
                            <span class="price-bg position-absolute"><img src="assets/img/bg/price-bg.png" alt=""></span>
                        </div>
                        <div class="bizx-pricing-price-text d-flex align-items-center justify-content-between">
                            <div class="bizx-pricing-text bzx-headline">
                                <h3>Strategy & Planning</h3>
                                <span>Save 29% on First Year</span>
                            </div>
                            <div class="bizx-price-pricing bzx-headline">
                                <h4>$14.99</h4>
                                <span>Monthly</span>
                            </div>
                        </div>
                    </div>
                    <div class="bizx-pricing-list-item-area ul-li-block">
                        <ul>
                            <li>Time for lead research, work</li>
                            <li>Trades & Stocks</li>
                            <li>Business Opportunities</li>
                            <li>What’s Happening</li>
                        </ul>
                        <div class="bizx-btn text-uppercase">
                            <a href="#">Get Started</a>
                        </div>
                    </div>

                </div>
            </div>
            
        </div>
	</section>	
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Business_Tab() );