<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Business_Growth extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-business-growth-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Business Growth', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Business Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape3', [
				'label' => esc_html__( 'Shape 3', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'growth_img', [
				'label' => esc_html__( 'Growth Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
        
        
		$this->add_control(
			'year', [
				'label' => esc_html__( 'Year', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'year_title', [
				'label' => esc_html__( 'Year Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape4', [
				'label' => esc_html__( 'Shape 4', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'list_description', [
				'label' => esc_html__( 'List Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		$this->add_control(
			'bigtitle', [
				'label' => esc_html__( 'Big Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'progress',
			[
				'label' => esc_html__( 'Add Progress Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        
		$this->end_controls_section();
		$this->start_controls_section(
			'bizex_style_option',
			[
				'label' => esc_html__( 'Growth STYLE', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_bg_color',
			[
				'label' => esc_html__( 'Section BG Color Color', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bz-growth-section' => 'background-color: {{VALUE}}',
				],
			]
		);

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-growth-section .bz-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bz-growth-section .bz-section-title h2',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Special-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-section-title h2 span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Description*/
        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Description-Color',
            [
                'label' => esc_html__( 'Section Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Description-Typography',
                'label' => 'Section Description Typography',
                'selector' => '{{WRAPPER}} .bz-section-title p',
            ]
        );

        /*Progress*/
        $this->add_control(
            '--Progress-Style-Heading--',
            [
                'label' => esc_html__( 'Progress Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Count-Color',
            [
                'label' => esc_html__( 'Count Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-growth-progress .skill-progress-bar .skill-set-percent .progress span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Count-Typography',
                'label' => 'Count Typography',
                'selector' => '{{WRAPPER}} .bz-growth-progress .skill-progress-bar .skill-set-percent .progress span',
            ]
        );
        $this->add_control(
            'Counter-Title-Color',
            [
                'label' => esc_html__( 'Counter Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-growth-progress .skill-progress-bar .skill-set-percent h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Counter-Title-Typography',
                'label' => 'Counter Title Typography',
                'selector' => '{{WRAPPER}} .bz-growth-progress .skill-progress-bar .skill-set-percent h4',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Counter-Progressbar-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-growth-progress .skill-progress-bar .skill-set-percent .progress-bar',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Counter Progressbar Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        /*Year*/
        $this->add_control(
            '--Year-Style-Heading--',
            [
                'label' => esc_html__( 'Year Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Year-Color',
            [
                'label' => esc_html__( 'Year Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-year h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Year-Typography',
                'label' => 'Year Typography',
                'selector' => '{{WRAPPER}} .bz-about-year h3',
            ]
        );
        $this->add_control(
            'Section-Year-Title-Color',
            [
                'label' => esc_html__( 'Year Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-year span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Year-Title-Typography',
                'label' => 'Year Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-year span',
            ]
        );

        /*List Style*/
        $this->add_control(
            '--List-Style-Heading--',
            [
                'label' => esc_html__( 'List Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-List-Color',
            [
                'label' => esc_html__( 'List Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-growth-section .bz-growth-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'List-Typography',
                'label' => 'List Typography',
                'selector' => '{{WRAPPER}} .bz-growth-section .bz-growth-list li',
            ]
        );

        /*Big-Title Style*/
        $this->add_control(
            '--Big-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Big Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Big-Title-Color',
            [
                'label' => esc_html__( 'Big Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-bottom-title' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Big-Title-Typography',
                'label' => 'Big Title Typography',
                'selector' => '{{WRAPPER}} .bz-bottom-title',
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bz-growth" class="bz-growth-section position-relative">
        <?php if(!empty($shape['url'])):?>
            <span class="bz-growth-shape1 position-absolute" data-parallax='{"y" : -50, "rotateY":500}'><img src="<?php echo esc_url($shape['url']);?>" alt=""></span>
        <?php endif;?>

        <?php if(!empty($shape2['url'])):?>
            <span class="bz-growth-shape2 position-absolute" data-parallax='{"x" : 50}'><img src="<?php echo esc_url($shape2['url']);?>" alt=""></span>
        <?php endif;?>

        <?php if(!empty($shape3['url'])):?>
            <span class="bz-growth-shape3 position-absolute wow slideInLeft" data-wow-delay="200ms" data-wow-duration="1500ms"><img src="<?php echo esc_url($shape3['url']);?>" alt=""></span>
        <?php endif;?>
        <?php if(!empty($year) || !empty($year_title)):?>
        <div class="bz-about-year text-center position-absolute headline wow slideInRight" data-wow-delay="200ms" data-wow-duration="1500ms">
            <h3><?php echo esc_html($year);?></h3>
			<span><?php echo esc_html($year_title);?></span>
        </div>
		<?php endif;?>
        <?php if(!empty($growth_img['url'])):?>
            <div class="bz-growth-img position-absolute wow slideInRight" data-wow-delay="400ms" data-wow-duration="1500ms">
                <img src="<?php echo esc_url($growth_img['url']);?>" alt="">
            </div>
        <?php endif;?>
        <?php if(!empty($shape4['url'])):?>
        <div class="bz-growth-circle-img position-absolute wow zoomIn" data-wow-delay="300ms" data-wow-duration="1500ms">
            <img src="<?php echo esc_url($shape4['url']);?>" alt="">
        </div>
        <?php endif;?>
		<?php if(!empty($list_description)):?>
        <div class="bz-growth-list position-absolute text-uppercase ul-li-block">
            <?php echo wp_kses( $list_description, true );?>
        </div>
		<?php endif;?>
        <?php if(!empty($bigtitle)):?>
            <div class="bz-bottom-title position-absolute text-uppercase wow slideInLeft" data-wow-delay="300ms" data-wow-duration="2000ms"><?php echo esc_html($bigtitle);?></div>
        <?php endif;?>
        <div class="container">
            <div class="bz-growth-content">
                <div class="bz-section-title pera-content headline wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
                    <h2><?php echo wp_kses( $title, true );?></h2>
                    <p><?php echo wp_kses( $description, true );?></p>
                </div>
                <div class="bz-growth-progress wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                    <div class="skill-progress-bar">
                        <?php foreach($progress as $item):?>
                        <div class="skill-set-percent headline">
                            <h4><?php echo wp_kses( $item['title'], true )?></h4>
                            <div class="progress">
                                <div class="progress-bar" data-percent="<?php echo esc_attr($item['count']);?>"></div>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Business_Growth() );