<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_Accordion extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-accordion-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Accordion', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'FAQ Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'is_active',
			[
				'label' => esc_html__( 'Active Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'YES', 'bizex-tools' ),
				'label_off' => esc_html__( 'NO', 'bizex-tools' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'accordions',
			[
				'label' => esc_html__( 'Add Accordions Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __('Section Style', 'appilo'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__('Title Color', 'bizex-tools'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-faq-feed-accordion .accordion-header button' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bz-faq-feed-accordion .accordion-button:not(.collapsed)',
            ]
        );

        $this->add_control(
            'Active-Title-Color',
            [
                'label' => esc_html__('Active Title Color', 'bizex-tools'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-faq-feed-accordion .accordion-button:not(.collapsed)' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__('Description Color', 'bizex-tools'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-faq-feed-accordion .accordion-body' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bz-faq-feed-accordion .accordion-body',
            ]
        );

		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div class="bz-faq-feed-accordion">
        <div class="accordion" id="accordionExample2">
            <?php foreach($settings['accordions'] as $item):?>
            <div class="accordion-item headline-2 pera-content wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms">
                <h2 class="accordion-header" id="headingOne2<?php echo esc_attr($item['_id']);?>">
                    <button class="accordion-button <?php if($item['is_active'] != 'yes'):?> collapsed <?php endif;?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne2<?php echo esc_attr($item['_id']);?>" aria-expanded="true" aria-controls="collapseOne<?php echo esc_attr($item['_id']);?>">
                        <?php echo wp_kses($item['title'], true)?>
                    </button>
                </h2>
                <div id="collapseOne2<?php echo esc_attr($item['_id']);?>" class="accordion-collapse collapse <?php if($item['is_active'] == 'yes'):?> show <?php endif;?>" aria-labelledby="headingOne2<?php echo esc_attr($item['_id']);?>" data-bs-parent="#accordionExample2">
                    <div class="accordion-body">
                    <?php echo wp_kses($item['description'], true)?>
                    </div>
                </div>
            </div>
            <?php endforeach;?>
        </div>
    </div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_Accordion() );