<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_About_Info_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-about-info-two-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Info Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'Service Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'big_title', [
				'label' => esc_html__( 'Big Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
        $this->add_control(
			'sub_title', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
        $this->add_control(
			'item_description',
			[
				'label' => esc_html__( 'List Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Add List item Here', 'bizex-tools' ),
			]
		);
		
        $repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'skill_percent', [
				'label' => esc_html__( 'Skill Percent', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'skill_bar',
			[
				'label' => esc_html__( 'Add Skill Item', 'bizex-tools' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
        $this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Btn Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'call_title', [
				'label' => esc_html__( 'Call Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'phone_no', [
				'label' => esc_html__( 'Phone NO', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'about_img_1', [
				'label' => esc_html__( 'About Image 1', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'about_img_2', [
				'label' => esc_html__( 'About Image 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
        $this->start_controls_section(
			'bizex_style',
			[
				'label' => esc_html__( 'Bizex Style Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        /*Sub Title*/
        $this->add_control(
            '--Subtitle-Style-Heading--',
            [
                'label' => esc_html__( 'Subtitle Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Subtitle-Color',
            [
                'label' => esc_html__( 'Subtitle Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Subtitle-Typography',
                'label' => 'Subtitle Typography',
                'selector' => '{{WRAPPER}} .bzx-section-title .subtitle',
            ]
        );
        $this->add_control(
            'Subtitle-BG-Color',
            [
                'label' => esc_html__( 'Subtitle BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title .subtitle' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Title*/
        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Title-Typography',
                'label' => 'Title Typography',
                'selector' => '{{WRAPPER}} .bzx-section-title h2',
            ]
        );

        /*Description*/
        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pera-content p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .pera-content p',
            ]
        );

        /*List-Style*/
        $this->add_control(
            '--List-Style-Heading--',
            [
                'label' => esc_html__( 'List Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'List-Style-Color',
            [
                'label' => esc_html__( 'List Style Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-about-feature-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'List-Style-Typography',
                'label' => 'List Style Typography',
                'selector' => '{{WRAPPER}} .bzx-about-feature-list li',
            ]
        );

        /*Skill-Style*/
        $this->add_control(
            '--Skill-Style-Heading--',
            [
                'label' => esc_html__( 'Skill Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Skill-Title-Color',
            [
                'label' => esc_html__( 'Skill Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-satisfection .skill-set-percent h4' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Skill-Title-Typography',
                'label' => 'Skill Title Typography',
                'selector' => '{{WRAPPER}} .bzx-satisfection .skill-set-percent h4',
            ]
        );
        $this->add_control(
            'Skill-Number-Color',
            [
                'label' => esc_html__( 'Skill Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-satisfection .skill-set-percent .progress span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Skill-Number-Typography',
                'label' => 'Skill Number Typography',
                'selector' => '{{WRAPPER}} .bzx-satisfection .skill-set-percent .progress span',
            ]
        );
        $this->add_control(
            'Skill-Progress-Bar-Color',
            [
                'label' => esc_html__( 'Skill Progress Bar Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-satisfection .skill-set-percent .progress-bar' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bzx-btn a',
            ]
        );
        $this->add_control(
            'Button-BG-Color',
            [
                'label' => esc_html__( 'Button BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-BG-Color',
            [
                'label' => esc_html__( 'Button Hover BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Hover-Icon-BG-Color',
            [
                'label' => esc_html__( 'Button Hover Icon BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-btn a:hover i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        /*Call Button*/
        $this->add_control(
            '--Call-Style-Heading--',
            [
                'label' => esc_html__( 'Call Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Call-Icon-Color',
            [
                'label' => esc_html__( 'Call Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-cta-text .cta-icon' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Call-Icon-BG-Color',
            [
                'label' => esc_html__( 'Call Icon BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-cta-text .cta-icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Call-Title-Color',
            [
                'label' => esc_html__( 'Call Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-cta-text .cta-text span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Call-Title-Typography',
                'label' => 'Call Title Typography',
                'selector' => '{{WRAPPER}} .bzx-cta-text .cta-text span',
            ]
        );
        $this->add_control(
            'Phone-Number-Color',
            [
                'label' => esc_html__( 'Phone Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bzx-cta-text .cta-text h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Phone-Number-Typography',
                'label' => 'Phone Number Typography',
                'selector' => '{{WRAPPER}} .bzx-cta-text .cta-text h3',
            ]
        );
		$this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <section id="bzx-about" class="bzx-about-section position-relative">
        <div class="bzx-about-content-wrapper position-relative">
            <div class="container">
                <div class="bzx-about-content">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="bzx-about-text-wrapper">
                                <div class="bzx-section-title bzx-headline pera-content position-relative">
                                    <?php if(!empty($settings['sub_title'])):?>
                                        <div class="subtitle text-uppercase wow fadeInDown" data-wow-delay="350ms" data-wow-duration="1500ms">
                                            <?php echo wp_kses($settings['sub_title'], true);?>
                                        </div> 
                                    <?php endif;?>
                                    <h2 data-splitting><?php echo wp_kses($settings['title'], true);?></h2>
                                    <?php if(!empty($settings['description'])):?>
                                        <p class="wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1500ms"><?php echo wp_kses($settings['description'], true);?>
                                        </p>
                                    <?php endif;?>
                                </div>
                                <div class="bzx-about-feature-content">
                                    <?php if(!empty($settings['item_description'])):?>
                                        <div class="bzx-about-feature-list clearfix ul-li-block">
                                            <?php echo wp_kses($settings['item_description'], true);?>
                                        </div>
                                    <?php endif;?>
                                    <div class="bzx-satisfection">
                                        <?php foreach($settings['skill_bar'] as $item):?>
                                            <div class="skill-set-percent bzx-headline">
                                                <h4><?php echo esc_html($item['title']);?></h4>
                                                <div class="progress">
                                                    <div class="progress-bar" data-percent="<?php echo esc_html($item['skill_percent']);?>"></div>
                                                </div>
                                            </div>
                                        <?php endforeach;?>
                                    </div>
                                    <div class="bzx-about-btn-cta d-flex align-items-center">
                                        <?php if(!empty($settings['btn_label'])):?>
                                        <div class="bzx-btn text-uppercase">
                                            <a href="<?php echo esc_url($settings['btn_link']['url']); ?>"><?php echo esc_html($settings['btn_label']);?> <i class="fal fa-long-arrow-right"></i></a>
                                        </div>
                                        <?php endif;?>
                                        <div class="bzx-cta-text d-flex align-items-center">
                                            <div class="cta-icon d-flex justify-content-center align-items-center">
                                                <i class="fal fa-phone-alt"></i>
                                            </div>
                                            <div class="cta-text">
                                                <span><?php echo esc_html($settings['call_title']);?></span>
                                                <h3><?php echo esc_html($settings['phone_no']);?></h3>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bzx-about-img-wrap d-flex position-absolute">
                <?php if(!empty($settings['about_img_1']['url'])):?>
                    <div class="bzx-about-img-1" data-parallax='{"y" : 100}'>
                        <img src="<?php echo esc_url($settings['about_img_1']['url']);?>" alt="">
                    </div>
                <?php endif;?>
                <?php if(!empty($settings['about_img_2']['url'])):?>
                    <div class="bzx-about-img-2" data-parallax='{"y" : -100}'>
                        <img src="<?php echo esc_url($settings['about_img_2']['url']);?>" alt="">
                    </div>
                <?php endif;?>
            </div>
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_About_Info_Two() );