<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_About_Info_Content extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-about-info-content-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Info Content', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'about_img', [
				'label' => esc_html__( 'About Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'prefix', [
				'label' => esc_html__( 'Prefix', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'counters',
			[
				'label' => esc_html__( 'Add Counter Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'list_description', [
				'label' => esc_html__( 'List Description', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);

		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);

		$this->add_control(
			'play_label', [
				'label' => esc_html__( 'Video Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'video_link', [
				'label' => esc_html__( 'Video Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();

        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'appilo' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        /*Description*/
        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bx-about-text-area-2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bx-about-text-area-2',
            ]
        );
        $this->add_control(
            'Description-Left-Border-Color',
            [
                'label' => esc_html__( 'Description Left Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bx-about-text-area-2:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        /*Counter*/
        $this->add_control(
            '--Counter-Style-Heading--',
            [
                'label' => esc_html__( 'Counter Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Counter-Color',
            [
                'label' => esc_html__( 'Counter Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-count-item h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Counter-Typography',
                'label' => 'Counter Typography',
                'selector' => '{{WRAPPER}} .bz-about-count-item h3',
            ]
        );
        $this->add_control(
            'Counter-Title-Color',
            [
                'label' => esc_html__( 'Counter Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-count-item p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Counter-Title-Typography',
                'label' => 'Counter Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-count-item p',
            ]
        );

        /*List-Item*/
        $this->add_control(
            '--List-Item-Style-Heading--',
            [
                'label' => esc_html__( 'List Item Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'List-Item-Color',
            [
                'label' => esc_html__( 'List Item Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-feature-list li' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'List-Item-Typography',
                'label' => 'List Item Typography',
                'selector' => '{{WRAPPER}} .bz-about-feature-list li',
            ]
        );
        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Color',
            [
                'label' => esc_html__( 'Button Hover Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn-2 a:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Icon-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn-2 a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Icon Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        /*Play Button*/
        $this->add_control(
            '--Play-Button-Style-Heading--',
            [
                'label' => esc_html__( 'Play Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Play-Button-Icon-Color',
            [
                'label' => esc_html__( 'Play Button Icon Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Play-Button-Border-Color',
            [
                'label' => esc_html__( 'Play Button Border Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a i' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Play-Button-Title-Color',
            [
                'label' => esc_html__( 'Play Button Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Play-Button-Title-Typography',
                'label' => 'Play Button Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-play-btn .bz-play-btn a span',
            ]
        );

        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div id="bz-about-2" class="bz-about-section-2 position-relative">
		<div class="container">
			<div class="bx-about-content-2">
				<div class="row">
					<div class="col-lg-6">
						<div class="bx-about-exp-img wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
							<img src="<?php echo esc_url($about_img['url']);?>" alt="">
						</div>
					</div>
					<div class="col-lg-6">
						<div class="bz-about-text-wrap-2">
							<div class="bx-about-text-area-2 wow fadeInUp" data-wow-delay="100ms" data-wow-duration="1500ms">
								<div class="bx-about-text">
									<?php echo wp_kses( $description, true );?>
								</div>
							</div>
							<div class="bz-about-counter d-flex wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1500ms">
                                <?php foreach($counters as $item):?>
								<div class="bz-about-count-item pera-content d-flex align-items-center">
									<h3><?php if(!empty($item['prefix'])){echo esc_attr($item['prefix']);}?><span class="counter"><?php echo esc_html($item['count']);?></span></h3>
									<p><?php echo esc_html($item['title']);?></p>
								</div>
                                <?php endforeach;?>
							</div>
							<div class="bz-about-feature-list ul-li-block wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1500ms">
                                <?php echo wp_kses( $list_description, true );?>
							</div>
							<div class="bz-about-play-btn d-flex align-items-center wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1500ms">
                                <?php if(!empty($btn_label)):?>
								<div class="bz-btn-2 text-uppercase">
									<a href="<?php echo esc_url($btn_link['url']);?>"><?php echo esc_html($btn_label);?> <i class="fas fa-long-arrow-right"></i></a>
								</div>
                                <?php endif;?>
                                <?php if(!empty($play_label)):?>
                                    <div class="bz-play-btn">
                                        <a class="video_box" href="<?php echo esc_url($video_link['url']);?>">
                                            <i class="fas fa-play"></i>
                                            <span><?php echo esc_html($play_label);?></span>
                                        </a>
                                    </div>
                                <?php endif;?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_About_Info_Content() );