<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_About_Info extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-about-info-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Info', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'about_img', [
				'label' => esc_html__( 'About Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'year', [
				'label' => esc_html__( 'Year', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'year_title', [
				'label' => esc_html__( 'Year Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape', [
				'label' => esc_html__( 'Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape3', [
				'label' => esc_html__( 'Shape 3', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'circle_shape', [
				'label' => esc_html__( 'Circle Shape', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'count', [
				'label' => esc_html__( 'Count', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$repeater->add_control(
			'data_fill_bg',
			[
				'label' => esc_html__( 'Data Fill BG Color', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);
		$repeater->add_control(
			'data_bg',
			[
				'label' => esc_html__( 'Data BG Color', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::COLOR,
			]
		);
		
		$repeater->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$this->add_control(
			'progress',
			[
				'label' => esc_html__( 'Add Progress Item', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);
		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->add_control(
			'signature', [
				'label' => esc_html__( 'Signature', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'bizex_style_option',
			[
				'label' => esc_html__( 'About STYLE', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'section_bg_color',
			[
				'label' => esc_html__( 'Section BG Color Color', 'bizex-tools' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bz-about-section' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Title-Color',
            [
                'label' => esc_html__( 'Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-content .bz-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-Special-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-about-content .bz-section-title h2 span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-content .bz-section-title h2',
            ]
        );

        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Description-Color',
            [
                'label' => esc_html__( 'Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-text-area' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Description-Typography',
                'label' => 'Description Typography',
                'selector' => '{{WRAPPER}} .bz-about-text-area',
            ]
        );

        /* Counter style*/
        $this->add_control(
            '--Counter-Style-Heading--',
            [
                'label' => esc_html__( 'Counter Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Number-Color',
            [
                'label' => esc_html__( 'Number Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-circle-progress .inner-text' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Number-Typography',
                'label' => 'Number Typography',
                'selector' => '{{WRAPPER}} .bz-about-circle-progress .inner-text',
            ]
        );
        $this->add_control(
            'Progressbar-Title-Color',
            [
                'label' => esc_html__( 'Progressbar Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-circle-progress p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Progressbar-Title-Typography',
                'label' => 'Progressbar Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-circle-progress p',
            ]
        );

        /*Year*/
        $this->add_control(
            '--Year-Style-Heading--',
            [
                'label' => esc_html__( 'Year Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Year-BG-Color',
            [
                'label' => esc_html__( 'Year BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-year' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Year-Color',
            [
                'label' => esc_html__( 'Year Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-year h3' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Year-Typography',
                'label' => 'Year Typography',
                'selector' => '{{WRAPPER}} .bz-about-year h3',
            ]
        );
        $this->add_control(
            'Year-Title-Color',
            [
                'label' => esc_html__( 'Year Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-about-year span' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Year-Title-Typography',
                'label' => 'Year Title Typography',
                'selector' => '{{WRAPPER}} .bz-about-year span',
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bz-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-Color',
            [
                'label' => esc_html__( 'Button Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'Button-Arrow-BG-Color',
            [
                'label' => esc_html__( 'Button Arrow BG Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a i' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Hover-Arrow-Color',
            [
                'label' => esc_html__( 'Button Hover Arrow Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bz-btn a:hover i' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Hover-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bz-btn a:hover i',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Hover Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
    ?>
    <div id="bz-about" class="bz-about-section  position-relative">

		<?php if(!empty($settings['about_img']['url'])):?>
			<div class="bz-about-img position-absolute wow slideInRight" data-wow-delay="650ms" data-wow-duration="2000ms"><img src="<?php echo esc_url($settings['about_img']['url']);?>" alt=""></div>
		<?php endif;?>
		<?php if(!empty($settings['year']) || !empty($settings['year_title'])):?>
		<div class="bz-about-year text-center position-absolute headline wow slideInRight" data-wow-delay="750ms" data-wow-duration="2000ms">
			<h3><?php echo esc_html($settings['year']);?></h3>
			<span><?php echo esc_html($settings['year_title']);?></span>
		</div>
		<?php endif;?>
		<?php if(!empty($settings['shape']['url'])):?>
			<div class="bz-about-shape1 position-absolute" data-parallax='{"y" : 50}'>
				<img src="<?php echo esc_url($settings['shape']['url']);?>" alt="">
			</div>
		<?php endif;?>

		<?php if(!empty($settings['shape2']['url'])):?>
			<div class="bz-about-shape2 position-absolute" data-parallax='{"x" : 50}'>
				<img src="<?php echo esc_url($settings['shape2']['url']);?>" alt="">
			</div>
		<?php endif;?>

		<?php if(!empty($settings['shape3']['url'])):?>
			<div class="bz-about-shape3 position-absolute" data-parallax='{"x" : 50}'>
				<img src="<?php echo esc_url($settings['shape3']['url']);?>" alt="">
			</div>
		<?php endif;?>
		
		<div class="container">
			<div class="bz-about-content-wrapper position-relative">
				<?php if(!empty($settings['circle_shape']['url'])):?>
					<div class="bz-about-circle-img position-absolute wow zoomIn" data-wow-delay="450ms" data-wow-duration="1500ms"><img src="<?php echo esc_url($settings['circle_shape']['url']);?>" alt=""></div>
				<?php endif;?>
				<div class="bz-about-content">
					<div class="bz-section-title headline wow fadeInUp" data-wow-delay="0ms" data-wow-duration="2000ms">
						<h2><?php echo wp_kses( $settings['title'], true )?></h2>
					</div>
					<div class="bz-about-text-area wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1000ms">
						<?php echo wp_kses( $settings['description'], true )?>
					</div>
					<div class="bz-about-circle-progress-area wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
						<div class="row">
							<?php foreach($settings['progress'] as $item):?>
							<div class="col-md-6">
								<div class="bz-about-circle-progress">
									<div class="counter-boxed headline pera-content position-relative d-flex align-items-center">
										<div class="graph-outer position-relative">
											<input type="text" class="dial" data-fgColor="<?php echo esc_attr($item['data_fill_bg']);?>" data-bgColor="<?php echo esc_attr($item['data_bg']);?>" data-width="<?php echo esc_attr($item['count']);?>" data-height="<?php echo esc_attr($item['count']);?>"  value="<?php echo esc_attr($item['count']);?>" >
											<div class="inner-text count-box"><span class="count-text" data-stop="<?php echo esc_attr($item['count']);?>" data-speed="4500"></span>%</div>
										</div>
										<p><?php echo wp_kses( $item['title'], true );?></p>
									</div>
								</div>
							</div>
							<?php endforeach;?>
						</div>
					</div>
					<div class="bz-about-btn-sign d-flex align-items-center wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1000ms">
						<?php if(!empty($settings['btn_label'])):?>
						<div class="bz-btn text-uppercase">
							<a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo esc_html($settings['btn_label']);?> <i class="fas fa-long-arrow-right"></i></a>
						</div>
						<?php endif;?>
						<?php if(!empty($settings['signature']['url'])):?>
							<div class="bz-about-sign">
								<img src="<?php echo esc_url($settings['signature']['url']);?>" alt="">
							</div>
						<?php endif;?>
					</div>
				</div>
			</div>
		</div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_About_Info() );