<?php

/**
 * Elementor Single Widget
 * @package bizex Tools
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class Bizex_About_Info_Content_Two extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'hos-about-info-content-tw-id';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'About Info Content Two', 'bizex-tools' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'appi-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bizex_widgets' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'bizex_sec_h_option',
			[
				'label' => esc_html__( 'About Option', 'bizex-tools' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'shape1', [
				'label' => esc_html__( 'Shape 1', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'about_img', [
				'label' => esc_html__( 'About Image', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape2', [
				'label' => esc_html__( 'Shape 2', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		$this->add_control(
			'shape3', [
				'label' => esc_html__( 'Shape 3', 'bizex-tools' ),
				'type' => Controls_Manager::MEDIA,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'subtitle', [
				'label' => esc_html__( 'Sub Title', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'title', [
				'label' => esc_html__( 'Title', 'bizex-tools' ),
				'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
			]
		);
		
		$this->add_control(
			'description', [
				'label' => esc_html__( 'Description', 'bizex-tools' ),
				'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);
		

		$this->add_control(
			'btn_label', [
				'label' => esc_html__( 'Button Label', 'bizex-tools' ),
				'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link', [
				'label' => esc_html__( 'Button Link', 'bizex-tools' ),
				'type' => Controls_Manager::URL,
                'label_block' => true,
			]
		);
		$this->end_controls_section();
        $this->start_controls_section(
            'section_style_1',
            [
                'label' => __( 'Section Style', 'bizex-tools' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            '--Sub-Title-Style-Heading--',
            [
                'label' => esc_html__( 'Sub Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'section-sub-title-color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Sub Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Sub-Title-Typography',
                'label' => 'Section Sub Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title .subtitle',
            ]
        );

        $this->add_control(
            '--Title-Style-Heading--',
            [
                'label' => esc_html__( 'Title Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Title-Color',
            [
                'label' => esc_html__( 'Section Title Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Title-Typography',
                'label' => 'Section Title Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title h2',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Section-Special-Title-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-section-title h2 span',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Section Special Title Color', 'bizex-tools'),
                    ],
                ],
            ]
        );

        $this->add_control(
            '--Description-Style-Heading--',
            [
                'label' => esc_html__( 'Description Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'Section-Description-Color',
            [
                'label' => esc_html__( 'Section Description Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Section-Description-Typography',
                'label' => 'Section Description Typography',
                'selector' => '{{WRAPPER}} .bizx-section-title p',
            ]
        );

        /*Button style*/
        $this->add_control(
            '--Button-Style-Heading--',
            [
                'label' => esc_html__( 'Button Style', 'bizex-tools' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('tpcnt');
        $this->start_controls_tab(
            'tab_controls_normal',
            [
                'label' => esc_html__( 'Normal', 'bizex-tools' ),
            ]
        );
        $this->add_control(
            'Button-Color',
            [
                'label' => esc_html__( 'Button Color', 'bizex-tools' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'Button-Typography',
                'label' => 'Button Typography',
                'selector' => '{{WRAPPER}} .bizx-btn a',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'Button-Background-Color',
                'types' => [ 'gradient' ],
                'selector' => '{{WRAPPER}} .bizx-btn a',
                'fields_options' => [
                    'background' => [
                        'label' => esc_html__('Button Background Color', 'bizex-tools'),
                    ],
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_controls_hover',
            [
                'label' => esc_html__( 'Hover', 'bizex-tools' ),
            ]
        );

        $this->add_control(
            'Button-Hover-Background-Position',
            [
                'label' => esc_html__( 'Button Hover Background Position', 'textdomain' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .bizx-btn a:hover' => 'background-position: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
	}


	protected function render() {
		$settings = $this->get_settings_for_display();	
        extract($settings);
    ?>
    <div class="bizx-about-content  position-relative">
		<?php if(!empty($settings['shape1']['url'])):?>
		<span class="bizx-about-star3 position-absolute" data-parallax='{"y" : 100, "rotateY":500}'><img src="<?php echo esc_url($settings['shape1']['url']);?>" alt=""></span>
		<?php endif;?>
		<div class="row">
			<div class="col-lg-5">
				<div class="bizx-about-img-wrap position-relative">
					<div class="bizx-about-img position-relative">
						<div class="bizx-img-shade wow"></div>
						<?php if(!empty($settings['about_img']['url'])):?>
							<img src="<?php echo esc_url($settings['about_img']['url']);?>" alt="">
						<?php endif;?>
					</div>
					<?php if(!empty($settings['shape2']['url'])):?>
						<span class="bizx-about-star1 position-absolute"><img src="<?php echo esc_url($settings['shape2']['url']);?>" alt=""></span>
					<?php endif;?>

					<?php if(!empty($settings['shape3']['url'])):?>
						<span class="bizx-about-star2 position-absolute"><img src="<?php echo esc_url($settings['shape3']['url']);?>" alt=""></span>
					<?php endif;?>

				</div>
			</div>
			<div class="col-lg-7">
				<div class="bizx-about-text-wrap">
					<div class="bizx-section-title bzx-headline pera-content wow fadeInUp" data-wow-delay="300ms" data-wow-duration="1000ms">
						<?php if(!empty($settings['subtitle'])):?>
							<div class="subtitle">
								<?php echo wp_kses($settings['subtitle'], true);?>
							</div>
						<?php endif;?>
						<h2><?php echo wp_kses($settings['title'], true);?></h2>
						<p><?php echo wp_kses($settings['description'], true);?></p>
					</div>
					<?php if(!empty($settings['btn_label'])):?>
						<div class="bizx-btn text-uppercase wow fadeInUp" data-wow-delay="500ms" data-wow-duration="1000ms">
							<a href="<?php echo esc_url($settings['btn_link']['url']);?>"><?php echo wp_kses($settings['btn_label'], true);?></a>
						</div>
					<?php endif;?>
				</div>
			</div>
		</div>
	</div>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new Bizex_About_Info_Content_Two() );