<?php
/**
 * All Elementor widget init
 * @package bizex
 * @since 1.0.0
 */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}

if ( !class_exists('bizex_Elementor_Widget_Init') ){

	class bizex_Elementor_Widget_Init{
		/*
		* $instance
		* @since 1.0.0
		* */
		private static $instance;
		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array($this,'_widget_categories') );
			//elementor widget registered
			add_action('elementor/widgets/register',array($this,'_widget_registered'));
			add_action('elementor/editor/after_enqueue_styles',array($this,'editor_style'));
		}
		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance(){
			if ( null == self::$instance ){
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager){
			$elements_manager->add_category(
				'bizex_widgets',
				[
					'title' => __( 'Bizex Addons', 'magezix-core' ),
					'icon' => 'fa fa-plug'
				]
			);
		}
		

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered(){
			if( !class_exists('Elementor\Widget_Base') ){
				return;
			}
			$elementor_widgets = array(	
				
				// bizex Theme Widgets
				'about_info',
				'counter',
				'section-title',
				'service',
				'button',
				'business-growth',
				'company-journey-carousel',
				'pricing-table',
				'testimonial',
				'news',
				'info-box',
				'hero_home_two',
				'exprience-gallery',
				'fanfact-content',
				'about_info_content',
				'service-list',
				'project-filter',
				'sponsor-slider',
				'team-carousel',
				'team',
				'testimonial-v2',
				'news-two',
				'home-contact',
				'breadcrumb',
				'project-filter',
				'project-info',
				'accordion',
				'contact-info',
				'project-masonary-filter',
				'cta',
				'sponsor-slider-two',
				'section-title-v2',
				'news-three',
				'testimonial-3',
				'faq',
				'why-choose',
				'project',
				'counter-two',
				'service-two',
				'about_info_two',
				'service-three',
				'about-info-content',
				'counter-three',
				'cta-two',
				'cta-three',
				'sponcor-slider-three',
				'skill-section',
				'team-carousel-v2',
				'news-four',
				'testimonial-quote',
				'testimonial-4',
				'portfolio-slider',
				'faq-two',
				'pricing-tab',
				'sponcor-slide-four',
				'news-five',
				'testimonial-5',
				'team2',
				'service-four',
				'logo',
				'menu-builder',
				'icon-box',
				'service-5',
				'team-3',
				'casestydy',
				'testimonial-6',
				'news-six',
				'icon-box-2',
				'service-6',
				'team-4',
				'casestudy-2',
				'testimonial-7',
				'news-7',
			);

		
			$elementor_widgets = apply_filters('bizex_elementor_widget',$elementor_widgets);

			if ( is_array($elementor_widgets) && !empty($elementor_widgets) ) {
				foreach ( $elementor_widgets as $widget ){
					$widget_file = 'plugins/elementor/widget/'.$widget.'.php';
					$template_file = locate_template($widget_file);
					if ( !$template_file || !is_readable( $template_file ) ) {
						$template_file = BIZEX_DIR_PATH.'/elementor/widgets/'.$widget.'.php';
					}
					if ( $template_file && is_readable( $template_file ) ) {
						include_once $template_file;
					}
				}
			}

		}

		public function editor_style(){
			$cs_icon = plugins_url( 'icons.png', __FILE__ );
			wp_add_inline_style( 'elementor-editor', '.elementor-element .icon .appi-custom-icon{content: url( '.$cs_icon.');width: 28px;}' );
		}


	}

	if ( class_exists('bizex_Elementor_Widget_Init') ){
		bizex_Elementor_Widget_Init::getInstance();
	}

}//end if