<?php
/*
Plugin Name: Bizex Tools
Plugin URI: https://themeforest.net/user/themexriver
Description: After install the bizex WordPress Theme, you must need to install this "bizex Tools" first to get all functions of bizex WP Theme.
Author: Raziul Islam
Author URI: http://themexriver.com/
Version: 1.0.5
Text Domain: bizex-tools
*/
if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

/**
 * Define Core Path
 */
define( 'BIZEX_VERSION', '1.0.3' );
define( 'BIZEX_DIR_PATH',plugin_dir_path(__FILE__) );
define( 'BIZEX_DIR_UR',plugin_dir_url(__FILE__) );
define( 'BIZEX_INC_PATH', BIZEX_DIR_PATH . '/inc' );
define( 'BIZEX_PLUGIN_IMG_PATH', BIZEX_DIR_UR . '/assets/img' );

/**
 * Css Framework Load
 */
if ( file_exists(BIZEX_DIR_PATH.'/lib/codestar-framework/codestar-framework.php') ) {
    require_once  BIZEX_DIR_PATH.'/lib/codestar-framework/codestar-framework.php';
}

// Elementor - Remove Font Awesome 
add_action( 'elementor/frontend/after_register_styles',function() {
    foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
      wp_deregister_style( 'elementor-icons-fa-' . $style );
    }
  }, 20 );
/**
 * Register Custom Widget
 *
 * @return void
 */
function bizex_cw_wisget(){
    register_widget( 'Bizex_Recent_Posts' );
}
add_action('widgets_init', 'bizex_cw_wisget');


/**
 * Deregister Elementor Animation
 *
 * @return void
 */
function bizex_de_reg() {
    wp_deregister_style( 'e-animations' );
}
add_action( 'wp_enqueue_scripts', 'bizex_de_reg' );

/**
 * Enqueue Admin Style
 *
 * @return void
 */
function bizex_enqueue_admin_customstyle() {
    wp_enqueue_style( 'custom_wp_admin_flaticon', get_template_directory_uri() . '/assets/css/flaticon.css', false, '1.0.0' );
    wp_enqueue_style( 'admin-style', BIZEX_DIR_UR . '/assets/css/admin-style.css', false, '1.0.0' );
}
add_action( 'admin_enqueue_scripts', 'bizex_enqueue_admin_customstyle' );
/**
 * Enqueue Frontent Style
 *
 * @return void
 */
function bizex_enqueue_customstyle() {
    wp_enqueue_style( 'bizex-carousel', BIZEX_DIR_UR . "assets/css/owl.carousel.css");
    wp_enqueue_style( 'bizex-con-css', BIZEX_DIR_UR . "assets/css/con-css.css");

    wp_enqueue_script('owl-carousel', BIZEX_DIR_UR . "assets/js/owl.carousel.min.js", ['jquery'], '1.0', true);
    wp_enqueue_script('bizex-addon', BIZEX_DIR_UR . "assets/js/addon.js", ['jquery'], '1.0', true);
}
add_action( 'wp_enqueue_scripts', 'bizex_enqueue_customstyle' );

/**
 * Recent Post Widget
 */
include_once BIZEX_INC_PATH . "/custom-widget/recent-post.php";


/**
 * Custom Metabox
 */
include_once BIZEX_INC_PATH . "/options/theme-metabox.php";

/**
 * Themeoption
 */
include_once BIZEX_INC_PATH . "/options/theme-option.php";

/**
 * Helper Function
 */
include_once BIZEX_INC_PATH . "/helper.php";

/**
 * Codestar Custom Icon Liberary
 */
include_once BIZEX_INC_PATH . "/csf-custom-icon.php";

/**
 * Elementor Configuration
 */
include_once BIZEX_DIR_PATH . "/elementor/elementor-init.php";

add_filter('wpcf7_autop_or_not', '__return_false');
