
<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version 	3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>
<?php if ( is_shop() ) : ?>
	<?php
	// Get options.
	$bimber_shop_page_id = wc_get_page_id('shop');
	$bimber_options = bimber_get_page_header_options( $bimber_shop_page_id );

	// Prepare template part data.
	set_query_var( 'bimber_title', woocommerce_page_title( false ) );

	if ( bimber_can_use_plugin( 'wp-subtitle/wp-subtitle.php' ) ) {
		set_query_var( 'bimber_subtitle', get_the_subtitle( $bimber_shop_page_id, '', '', false ) );
	}

	// Load template part.
	get_template_part( 'template-parts/page/header', $bimber_options['composition'] );
	?>
<?php else : ?>
	<header class="g1-row g1-row-layout-page page-header page-header-01 archive-header">
		<div class="g1-row-inner">
			<div class="g1-column">

				<?php
				if ( bimber_show_breadcrumbs() ) {
					bimber_render_breadcrumbs();
				}
				?>

				<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
					<h1 class="g1-alpha g1-alpha-2nd page-title"><?php woocommerce_page_title(); ?></h1>
				<?php endif; ?>

				<?php
				if ( ! is_shop() ) :
					/**
					 * woocommerce_archive_description hook.
					 *
					 * @hooked woocommerce_taxonomy_archive_description - 10
					 * @hooked woocommerce_product_archive_description - 10
					 */
					do_action( 'woocommerce_archive_description' );
				endif;
				?>

			</div>
		</div>

		<div class="g1-row-background">
		</div>
	</header>
<?php endif; ?>

<?php
	if ( is_shop() ) :
	/**
	* woocommerce_archive_description hook.
	*
	* @hooked woocommerce_taxonomy_archive_description - 10
	* @hooked woocommerce_product_archive_description - 10
	*/
	do_action( 'woocommerce_archive_description' );
endif;
?>

	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>

		<?php if ( woocommerce_product_loop() ) : ?>

			<?php
				/**
				 * woocommerce_before_shop_loop hook.
				 *
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				do_action( 'woocommerce_before_shop_loop' );
			?>

			<?php woocommerce_product_loop_start(); ?>

				<?php woocommerce_product_subcategories(); ?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php wc_get_template_part( 'content', 'product' ); ?>

				<?php endwhile; // end of the loop. ?>

			<?php woocommerce_product_loop_end(); ?>

			<?php
				/**
				 * woocommerce_after_shop_loop hook.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action( 'woocommerce_after_shop_loop' );
			?>

		<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

			<?php wc_get_template( 'loop/no-products-found.php' ); ?>

		<?php endif; ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>

	<?php
		/**
		 * woocommerce_sidebar hook.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action( 'woocommerce_sidebar' );
	?>

<?php get_footer( 'shop' ); ?>
