<?php
/**
 * The template part for displaying the footer stamp
 *
 * @package Bimber_Theme 4.10
 */

?>
<?php
$bimber_footer_stamp            = bimber_get_footer_stamp();
$bimber_footer_stamp_label      = bimber_get_theme_option( 'footer', 'stamp_label' );
$bimber_footer_stamp_label_hide = bimber_get_theme_option( 'footer', 'stamp_label_hide' );
if ( ! $bimber_footer_stamp && ! $bimber_footer_stamp_label ) {
	return;
}
?>

<?php if ( ! empty( $bimber_footer_stamp ) ) : ?>
	<?php if ( $bimber_footer_stamp_label_hide ) : ?>
		<a class="g1-footer-stamp" href="<?php echo esc_url( bimber_get_theme_option( 'footer', 'stamp_url' ) ); ?>" title="<?php echo esc_attr( $bimber_footer_stamp_label ); ?>">
	<?php else: ?>
		<a class="g1-footer-stamp" href="<?php echo esc_url( bimber_get_theme_option( 'footer', 'stamp_url' ) ); ?>">
	<?php endif; ?>
		<?php
		printf(
			'<img class="g1-footer-stamp-icon" width="%d" height="%d" src="%s" %s alt="" />',
			absint( $bimber_footer_stamp['width'] ),
			absint( $bimber_footer_stamp['height'] ),
			esc_url( $bimber_footer_stamp['src'] ),
			isset( $bimber_footer_stamp['srcset'] ) ? sprintf( 'srcset="%s"', esc_url( $bimber_footer_stamp['srcset'] ) . ' 2x' ) : ''
		);
		?>
		<?php if ( !$bimber_footer_stamp_label_hide && strlen( $bimber_footer_stamp_label ) ) : ?>
			<span class="g1-footer-stamp-label"><?php echo esc_html( $bimber_footer_stamp_label ); ?></span>
		<?php endif; ?>
	</a>
<?php endif;
