<?php
/**
 * WP Customizer panel section to handle the Link post format options
 *
 * @license For the full license information, please view the Licensing folder
 * that was distributed with this source code.
 *
 * @package Bimber_Theme
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$bimber_option_name = bimber_get_theme_id();

$wp_customize->add_section( 'bimber_posts_link_section', array(
	'title'    => esc_html__( 'Link Post Format', 'bimber' ),
	'priority' => 30,
	'panel'    => 'bimber_posts_panel',
) );

// Single post page.
$wp_customize->add_setting( $bimber_option_name . '[post_link_single_page]', array(
	'default'           => $bimber_customizer_defaults['post_link_single_page'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'bimber_post_link_single_page', array(
	'label'         => esc_html__( 'Has a single page?', 'bimber' ),
	'section'  => 'bimber_posts_link_section',
	'settings' => $bimber_option_name . '[post_link_single_page]',
	'type'     => 'select',
	'choices'  => array(
		'none'      => __( 'No', 'bimber' ),
		'standard'  => __( 'Yes', 'bimber' ),
	),
) );

// Open method.
$wp_customize->add_setting( $bimber_option_name . '[post_link_open_method]', array(
	'default'           => $bimber_customizer_defaults['post_link_open_method'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'bimber_post_link_open_method', array(
	'label'         => esc_html__( 'Open method', 'bimber' ),
	'section'  => 'bimber_posts_link_section',
	'settings' => $bimber_option_name . '[post_link_open_method]',
	'type'     => 'select',
	'choices'  => array(
		'new_window'    => esc_html__( 'in a new window', 'bimber' ),
		'same_window'   => esc_html__( 'in the same window', 'bimber' ),
		'landing_page'  => esc_html__( 'using landing page', 'bimber' ),
	),
) );

// Landing page.
$wp_customize->add_setting( $bimber_option_name . '[post_link_landing_page]', array(
	'default'           => $bimber_customizer_defaults['post_link_landing_page'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
) );

$wp_customize->add_control( 'bimber_post_link_landing_page', array(
	'label'             => esc_html__( 'Landing page', 'bimber' ),
	'description'       => esc_html__( 'Run an external link redirection from a separate page.', 'bimber' ),
	'section'           => 'bimber_posts_link_section',
	'settings'          => $bimber_option_name . '[post_link_landing_page]',
	'type'              => 'dropdown-pages',
	'active_callback'   => 'bimber_customizer_is_link_opened_using_landing_page',
) );

// Delay.
$wp_customize->add_setting( $bimber_option_name . '[post_link_redirection_delay]', array(
	'default'           => $bimber_customizer_defaults['post_link_redirection_delay'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'absint',
) );

$wp_customize->add_control( 'bimber_post_link_redirection_delay', array(
	'label'             => esc_html__( 'Redirection delay (in seconds)', 'bimber' ),
	'description'       => esc_html__( 'Set to 0 to disable the delay counter.', 'bimber' ),
	'section'           => 'bimber_posts_link_section',
	'settings'          => $bimber_option_name . '[post_link_redirection_delay]',
	'type'              => 'number',
	'active_callback'   => 'bimber_customizer_is_link_opened_using_landing_page',
) );

/**
 * Check whether there are many comment types active
 *
 * @param WP_Customize_Control $control     Control instance for which this callback is executed.
 *
 * @return bool
 */
function bimber_customizer_is_link_opened_using_landing_page( $control ) {
	$open_method = $control->manager->get_setting( bimber_get_theme_id() . '[post_link_open_method]' )->value();

	return ( 'landing_page' === $open_method );
}
