<?php
/**
 * WP Customizer panel section to handle general design options
 *
 * @license For the full license information, please view the Licensing folder
 * that was distributed with this source code.
 *
 * @package Bimber_Theme
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$bimber_option_name = bimber_get_theme_id();

$wp_customize->add_section( 'bimber_design_general_section', array(
	'title'    => esc_html__( 'General', 'bimber' ),
	'priority' => 10,
	'panel'    => 'bimber_design_panel',
) );
$wp_customize->add_section( 'bimber_design_colors_section', array(
	'title'    => esc_html__( 'Colors', 'bimber' ),
	'priority' => 11,
	'panel'    => 'bimber_design_panel',
) );

$wp_customize->add_section( 'bimber_design_colors_flags_section', array(
	'title'    => __( 'Colors', 'bimber' ) . ' - ' . __( 'Flags', 'bimber' ),
	'priority' => 11,
	'panel'    => 'bimber_design_panel',
) );


// Stack.
$wp_customize->add_setting( $bimber_option_name . '[global_stack]', array(
	'default'           => $bimber_customizer_defaults['global_stack'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$the_choices = array(
	'app' 			=> 'app',
	'bunchy'        => 'bunchy',
	'cards'         => 'cards',
	'carmania'		=> 'carmania',
	'fashion'  		=> 'fashion',
	'food'  		=> 'food',
	'hardcore'      => 'hardcore',
	'miami'         => 'miami',
	'minimal'       => 'minimal',
	'music'         => 'music',
	'original'      => 'original',
	'original-2018' => 'original 2018',
	'video'         => 'video',
);


$wp_customize->add_control( 'bimber_global_stack', array(
	'label'    => esc_html__( 'Style', 'bimber' ),
	'section'  => 'bimber_design_general_section',
	'settings' => $bimber_option_name . '[global_stack]',
	'type'     => 'select',
	'choices'  => $the_choices,
) );


// Skin.
$wp_customize->add_setting( $bimber_option_name . '[global_skin]', array(
	'default'           => $bimber_customizer_defaults['global_skin'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'bimber_global_skin', array(
	'label'    => esc_html__( 'Skin', 'bimber' ),
	'section'  => 'bimber_design_general_section',
	'settings' => $bimber_option_name . '[global_skin]',
	'type'     => 'select',
	'choices'  => array(
		'light'  => _x( 'Light', 'skin', 'bimber' ),
		'dark'   => _x( 'Dark',  'skin', 'bimber' ),
	),
) );

// Page layout.
$wp_customize->add_setting( $bimber_option_name . '[global_layout]', array(
	'default'           => $bimber_customizer_defaults['global_layout'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'bimber_global_layout', array(
	'label'    => esc_html__( 'Layout', 'bimber' ),
	'section'  => 'bimber_design_general_section',
	'settings' => $bimber_option_name . '[global_layout]',
	'type'     => 'select',
	'choices'  => array(
		'boxed'     => _x( 'Boxed', 'layout', 'bimber' ),
		'stretched' => _x( 'Stretched', 'layout', 'bimber' ),
	),
) );

// Background Color.
$wp_customize->add_setting( $bimber_option_name . '[global_background_color]', array(
	'default'           => $bimber_customizer_defaults['global_background_color'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_hex_color',
) );

$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bimber_global_background_color', array(
	'label'    => __( 'Boxed Layout Background', 'bimber' ),
	'section'  => 'bimber_design_colors_section',
	'settings' => $bimber_option_name . '[global_background_color]',
) ) );

// Icon style.
$wp_customize->add_setting( $bimber_option_name . '[global_icon_style]', array(
	'default'           => $bimber_customizer_defaults['global_icon_style'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'bimber_global_icon_style', array(
	'label'    => esc_html__( 'Icon Style', 'bimber' ),
	'section'  => 'bimber_design_general_section',
	'settings' => $bimber_option_name . '[global_icon_style]',
	'type'     => 'select',
	'choices'  => array(
		'default'   => __( 'Default', 'bimber' ),
		'solid'  	=> _x( 'Solid', 'icon style', 'bimber' ),
		'line'     	=> _x( 'Line',  'icon style', 'bimber' ),
	),
) );


// Google Font Subset.
$wp_customize->add_setting( $bimber_option_name . '[global_google_font_subset]', array(
	'default'           => $bimber_customizer_defaults['global_google_font_subset'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Bimber_Customize_Multi_Checkbox_Control( $wp_customize, 'bimber_global_google_font_subset', array(
	'label'    => __( 'Google Font Subset', 'bimber' ),
	'section'  => 'bimber_design_general_section',
	'settings' => $bimber_option_name . '[global_google_font_subset]',
	'choices'  => array(
		'latin'        => _x( 'Latin',              'font subset', 'bimber' ),
		'latin-ext'    => _x( 'Latin Extended',     'font subset', 'bimber' ),
		'cyrillic'     => _x( 'Cyrillic',           'font subset', 'bimber' ),
		'cyrillic-ext' => _x( 'Cyrillic Extended',  'font subset', 'bimber' ),
		'greek'        => _x( 'Greek',              'font subset', 'bimber' ),
		'greek-ext'    => _x( 'Greek Extended',     'font subset', 'bimber' ),
		'vietnamese'   => _x( 'Vietnamese',         'font subset', 'bimber' ),
	),
) ) );

// Breadcrumbs.
$wp_customize->add_setting( $bimber_option_name . '[breadcrumbs]', array(
	'default'           => $bimber_customizer_defaults['breadcrumbs'],
	'type'              => 'option',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'bimber_breadcrumbs', array(
	'label'    => esc_html__( 'Breadcrumbs', 'bimber' ),
	'section'  => 'bimber_design_general_section',
	'settings' => $bimber_option_name . '[breadcrumbs]',
	'type'     => 'select',
	'choices'  => array(
		'standard'  => __( 'Show', 'bimber' ),
		'none'      => __( 'Hide', 'bimber' ),
	),
) );
