<?php
/**
 * Bimber Theme functions and definitions
 *
 * @license For the full license information, please view the Licensing folder
 * that was distributed with this source code.
 *
 * @package Bimber_Theme 4.10
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

define( 'BIMBER_THEME_DIR',         trailingslashit( get_template_directory() ) );
define( 'BIMBER_THEME_DIR_URI',     trailingslashit( get_template_directory_uri() ) );
define( 'BIMBER_INCLUDES_DIR',      trailingslashit( get_template_directory() ) . 'includes/' );
define( 'BIMBER_ADMIN_DIR',         trailingslashit( get_template_directory() ) . 'includes/admin/' );
define( 'BIMBER_ADMIN_DIR_URI',     trailingslashit( get_template_directory_uri() ) . 'includes/admin/' );
define( 'BIMBER_FRONT_DIR',         trailingslashit( get_template_directory() ) . 'includes/front/' );
define( 'BIMBER_FRONT_DIR_URI',     trailingslashit( get_template_directory_uri() ) . 'includes/front/' );
define( 'BIMBER_PLUGINS_DIR',       trailingslashit( get_template_directory() ) . 'includes/plugins/' );
define( 'BIMBER_PLUGINS_DIR_URI',   trailingslashit( get_template_directory_uri() ) . 'includes/plugins/' );

// Load common resources (required by both, admin and front, contexts).
require_once BIMBER_INCLUDES_DIR . 'functions.php';

// Load context resources.
if ( is_admin() ) {
	require_once BIMBER_ADMIN_DIR . 'functions.php';
} else {
	require_once BIMBER_FRONT_DIR . 'functions.php';
}


add_filter( 'img_caption_shortcode_width', 'bimber_img_caption_shortcode_width', 11, 3 );
function bimber_img_caption_shortcode_width( $width, $atts, $content ) {
	if ( 'aligncenter' === $atts['align'] ) {
		$width = 0;
	}

	return $width;
}

add_filter( 'widgettitle_class', 'bimber_widgettitle_class' );
function bimber_widgettitle_class( $class ) {
	if ( 'original-2018' === bimber_get_current_stack() ) {
		$class[] = 'g1-epsilon';
		$class[] = 'g1-epsilon-2nd';
	} else {
		$class[] = 'g1-delta';
		$class[] = 'g1-delta-2nd';
	}

	return $class;
}

function bimber_the_permalink( $permalink ) {
	return apply_filters( 'bimber_the_permalink', $permalink );
}

add_filter( 'gettext_with_context', 'bimber_recent_comments_change_markup', 10, 4 );
function bimber_recent_comments_change_markup( $translated, $text, $context, $domain ) {
	if ( '%1$s on %2$s' == $text && 'widgets' == $context && 'default' == $domain ) {
		$translated = _x('<div class="g1-meta">%1$s on </div><div class="entry-title g1-epsilon g1-epsilon-1st">%2$s</div>', 'widgets', 'bimber');
	}

	return $translated;
}


add_filter( 'bimber_single_featured_media_allow_video', 'bimber_single_featured_media_allow_video' );
function bimber_single_featured_media_allow_video( $formats ) {
	if ( (bool) bimber_get_theme_option( 'post_video', 'single_featured_media_allow_video' ) ) {
		$formats[] = 'video';
	}

	return $formats;
}





add_filter( 'bimber_html_class', 'bimber_html_class_canvas' );
function bimber_html_class_canvas( $classes ) {
	$sticky = explode( ',', bimber_get_theme_option( 'canvas', 'sticky' ) );

	if ( count( array_intersect( array('home', 'all'), $sticky ) ) ) {
		$classes[] = 'g1-off-inside';
	}

	$is_sticky = false;

	if ( in_array( 'all', $sticky ) ) {
		$is_sticky = true;
	} else {
		if ( is_home() && in_array( 'home', $sticky ) ) {
			$is_sticky = true;
		}
	}

	if ( $is_sticky ) {
		$classes[] = 'g1-off-global-desktop';
	}

	return $classes;
}




add_filter( 'snax_entry_action_links_args', 'bimber_snax_entry_action_links_args', 999 );
function bimber_snax_entry_action_links_args( $args ) {
	$args['before'] = '<div class="snax-actions"><p>';
	$args['after'] = '</p></div>';
	$args['sep'] = '';

	foreach( $args['links'] as $k => $v ) {
		$args['links'][ $k ] = str_replace( 'class="', 'class="g1-button g1-button-s g1-button-subtle ', $v );
	}

	return $args;
}
