<?php
/**
 * BuddyPress - Members Loop item
 *
 * @package Bimber
 */

 
// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}
?>


<div class="g1-members-item">
	<?php if ( bp_displayed_user_use_cover_image_header() ) : ?>
		<?php
			$member_cover_image_url = bp_attachments_get_attachment('url', array(
				'object_dir'    => 'members',
				'item_id'       => bp_get_member_user_id(),
			));
			$member_cover_image_url = apply_filters( 'bimber_bp_member_cover_image_url', $member_cover_image_url );

			printf(
				'<a class="item-cover" href="%s" title="%s" %s></a>',
				esc_url( bp_get_member_permalink() ),
				esc_attr( sprintf( __( 'Profile page of %s', 'bimber'), apply_filters( 'bp_member_name', bp_get_member_name() ) ) ),
				empty( $member_cover_image_url ) ? '' : 'style="background-image: url(' . esc_url( $member_cover_image_url ) . ')"'
			);
		?>
	<?php endif; ?>

	<div class="item-avatar">
		<a href="<?php bp_member_permalink(); ?>"><?php bp_member_avatar(array(
				'width'     => 80,
				'height'    => 80,
				'type'      => 'full',
			));
			do_action( 'bimber_buddypress_memebers_after_avatar', bp_get_member_user_id() );
			?>
		</a>
	</div>

	<div class="g1-gamma g1-gamma-1st entry-title item-title">
		<a href="<?php bp_member_permalink(); ?>"><?php bp_member_name(); ?></a>
	</div>

	<div class="item-desc">
		<?php
		$bimber_description = xprofile_get_field_data( bimber_bp_get_short_description_field_id(), bp_get_member_user_id() );
		echo esc_html( strip_tags( $bimber_description ) );?>
	</div>

	<div class="item-extras">
		<?php
			/**
			 * Fires inside the display of a directory member item.
			 *
			 * @since 1.1.0
		`	 */
			do_action( 'bp_directory_members_item' );
		?>
	</div>
</div>
