<?php
/**
 * The Template for displaying the dropable mini cart.
 *
 * @package Bimber_Theme 4.10
 * @license For the full license information, please view the Licensing folder
 * that was distributed with this source code.
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}
?>
<?php if ( bimber_can_use_plugin( 'woocommerce/woocommerce.php' ) && apply_filters( 'bimber_show_mini_cart', true ) ) : ?>
	<?php $bimber_count = WC()->cart->get_cart_contents_count(); ?>
	<div class="g1-drop g1-drop-before g1-drop-the-cart">
		<a class="g1-drop-toggle" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
			<i class="g1-drop-toggle-icon"></i><?php esc_html_e( 'Search', 'bimber' ); ?>
				<?php if ( $bimber_count ) : ?>
					<span class="g1-drop-toggle-badge"><?php echo (int) $bimber_count; ?></span>
				<?php else : ?>
					<span class="g1-drop-toggle-badge g1-drop-toggle-badge-hidden">0</span>
				<?php endif; ?>
			<span class="g1-drop-toggle-arrow"></span>
		</a>

		<div class="g1-drop-content">
			<?php the_widget( 'WC_Widget_Cart', 'title=' ); ?>
		</div>

	</div>
<?php endif;