<?php
/**
 *  The template for displaying featured entries
 *
 * @license For the full license information, please view the Licensing folder
 * that was distributed with this source code.
 *
 * @package Bimber_Theme 4.10
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$bimber_type = bimber_get_theme_option( 'featured_entries', 'type' );

if ( 'none' === $bimber_type ) {
	return;
}
$bimber_template = bimber_get_theme_option( 'featured_entries', 'template' );
$class = array(
	'g1-row-inner'
);
if ( 'bunchy' === $bimber_template ) {
	get_template_part( 'template-parts/collection-featured-bunchy' );
	return;
}
$bimber_query = bimber_get_global_featured_entries_query();

?>

<?php if ( $bimber_query->have_posts() ) : ?>
	<aside class="g1-row g1-row-layout-page g1-featured-row">
		<div class="<?php echo implode( ' ', array_map( 'sanitize_html_class', $class ) ); ?>">
			<div class="g1-column">
				<?php
				$bimber_title = esc_html__( 'Latest stories', 'bimber' );
				switch ( $bimber_type ) {
					case 'most_viewed':
						$bimber_title = esc_html__( 'Most viewed stories', 'bimber' );
						break;

					case 'most_shared':
						$bimber_title = esc_html__( 'Most shared stories', 'bimber' );
						break;
				}

				$bimber_template = bimber_get_theme_option( 'featured_entries', 'template' );
				switch ( $bimber_template ) {
					case 'list':
						$bimber_template = 'template-parts/content-list-xs';
						break;

					case 'grid_4':
						$bimber_template = 'template-parts/content-grid-xs-4';
						break;

					case 'grid_5':
						$bimber_template = 'template-parts/content-grid-xs-5';
						break;

					default:
						$bimber_template = 'template-parts/content-grid-xs';
						break;
				}

				$bimber_class = array(
					'g1-featured',
					'g1-featured-' . $bimber_query->query['posts_per_page'],
					'g1-featured-start'
				);

				if ( bimber_get_theme_option( 'featured_entries', 'gutter' ) ) {
					$bimber_class[] = 'g1-featured-with-gutter';
				}
				?>

				<h2 class="g1-zeta g1-zeta-2nd g1-featured-title"><?php echo wp_kses_post( $bimber_title ); ?></h2>

				<div class="<?php echo implode( ' ', array_map( 'sanitize_html_class', $bimber_class ) ); ?>">
					<ul class="g1-featured-items">
						<?php while ( $bimber_query->have_posts() ) : $bimber_query->the_post(); ?>

							<li class="g1-featured-item">
								<?php
									set_query_var( 'bimber_media_ratio', bimber_get_theme_option( 'featured_entries', 'img_ratio' ) );
									get_template_part( $bimber_template, get_post_format() );
								?>
							</li>

						<?php endwhile; wp_reset_postdata(); ?>
					</ul>

					<a href="#" class="g1-featured-arrow g1-featured-arrow-prev"><?php esc_html_e( 'Previous', 'bimber' ) ?></a>
					<a href="#" class="g1-featured-arrow g1-featured-arrow-next"><?php esc_html_e( 'Next', 'bimber' ) ?></a>
					<div class="g1-featured-fade g1-featured-fade-before"></div>
					<div class="g1-featured-fade g1-featured-fade-after"></div>
				</div>
			</div>
		</div>
		<div class="g1-row-background"></div>
	</aside>
<?php else : ?>
	<aside class="g1-row g1-row-layout-page g1-featured-row">
		<div class="g1-row-inner">
			<div class="g1-column">
				<div class="g1-featured-no-results">
					<p>
						<?php esc_html_e( 'No featured entries match the criteria.', 'bimber' ); ?><br/>
						<?php esc_html_e( 'For more information please refer to the documentation.', 'bimber' ); ?>
					</p>
				</div>
			</div>
		</div>
	</aside>
<?php endif;
