<?php
/**
 * Sets up the default filters and actions.
 *
 * @license For the full license information, please view the Licensing folder
 * that was distributed with this source code.
 *
 * @package Bimber_Theme
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

// Set up.
add_action( 'after_setup_theme', 'bimber_setup_theme' );
add_action( 'after_switch_theme', 'bimber_load_default_options' );
add_action( 'widgets_init', 'bimber_setup_sidebars', 1 );
add_action( 'after_setup_theme', 'bimber_setup_wpml' );
add_action( 'after_setup_theme', 'bimber_setup_content_width', 0 );
add_filter( 'widget_title', 'bimber_allow_empty_widget_title', 9999 );

// Migration.
add_action( 'after_setup_theme', 'bimber_run_migration' );
add_action( 'after_setup_theme', 'bimber_run_bunchy_migration',20 );

// Widgets.
add_action( 'wp_register_sidebar_widget', 'bimber_wp_register_sidebar_widget' );
add_action( 'widgets_init', 'bimber_widgets_init' );
add_action( 'dynamic_sidebar_after', 'bimber_close_sticky_sidebar_wrapper', 10, 2 );

// Lists.
add_action( 'bimber_update_hot_posts',      'bimber_calculate_hot_posts' );
add_action( 'bimber_update_popular_posts',  'bimber_calculate_popular_posts' );
add_action( 'bimber_update_trending_posts', 'bimber_calculate_trending_posts' );

// Lists.
add_filter( 'bimber_popular_post_ids',     'bimber_calculate_popular_post_ids_if_empty', 10, 2 );
add_filter( 'bimber_hot_post_ids',         'bimber_calculate_hot_post_ids_if_empty', 10, 2 );
add_filter( 'bimber_trending_post_ids',    'bimber_calculate_trending_post_ids_if_empty', 10, 2 );

// Embeds.
add_filter( 'embed_defaults', 'bimber_embed_defaults', 10, 2 );
add_filter( 'embed_oembed_html', 'bimber_fluid_wrapper_embed_oembed_html', 10, 999 );
add_filter( 'bimber_apply_fluid_wrapper_for_oembed', 'bimber_apply_fluid_wrapper_for_services', 10, 2 );

// Ajax.
add_action( 'wp_ajax_bimber_search', 'bimber_ajax_search' );
add_action( 'wp_ajax_nopriv_bimber_search', 'bimber_ajax_search' );

// Fakes.
add_filter( 'bimber_entry_view_count', 	'bimber_fake_view_count', 11 );

// Shortcodes.
add_filter( 'shortcode_atts_video', 'bimber_wp_video_shortcode_atts', 10, 3 );

